/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.enhydra.jdbc.core.CoreConnection;
import org.enhydra.jdbc.standard.PreparedStatementCache;
import org.enhydra.jdbc.standard.StandardPooledConnection;
import org.enhydra.jdbc.standard.StandardPreparedStatement;
import org.enhydra.jdbc.util.LRUCache;

public class StandardConnectionHandle
extends CoreConnection {
    StandardPooledConnection pooledCon;
    protected Hashtable masterPrepStmtCache;
    int preparedStmtCacheSize;
    protected LRUCache preparedStatementCache = null;
    public Hashtable inUse;
    private boolean closed;
    public boolean isReallyUsed = false;

    public StandardConnectionHandle(StandardPooledConnection pooledCon, Hashtable preparedStatementCache, int preparedStmtCacheSize) {
        super(pooledCon.getPhysicalConnection());
        this.pooledCon = pooledCon;
        this.masterPrepStmtCache = preparedStatementCache;
        this.preparedStmtCacheSize = preparedStmtCacheSize;
        this.log = pooledCon.dataSource.log;
        this.setupPreparedStatementCache();
        this.inUse = new Hashtable(10, 0.5f);
        this.log.debug("StandardConnectionHandle:new StandardConnectionHandle with " + preparedStmtCacheSize + " prepared statement");
    }

    protected void setupPreparedStatementCache() {
        this.log.debug("StandardConnectionHandle:setupPreparedStatementCache start");
        if (this.preparedStmtCacheSize == 0) {
            this.log.debug("StandardConnectionHandle:setupPreparedStatementCache return with 0");
            this.preparedStatementCache = null;
            return;
        }
        if (this.con == null) {
            this.log.warn("Connection is null");
        } else {
            this.preparedStatementCache = (LRUCache)this.masterPrepStmtCache.get(this.con.toString());
            if (this.preparedStatementCache == null) {
                this.preparedStatementCache = new PreparedStatementCache(this.preparedStmtCacheSize);
                this.preparedStatementCache.setLogger(this.log);
                this.masterPrepStmtCache.put(this.con.toString(), this.preparedStatementCache);
                this.log.debug("StandardConnectionHandle:setupPreparedStatementCache preparedStatementCache.size(lru)='" + this.preparedStatementCache.LRUSize() + "' " + "preparedStatementCache.size(cache)='" + this.preparedStatementCache.cacheSize() + "' " + "masterPrepStmtCache.size='" + this.masterPrepStmtCache.size() + "' ");
            }
        }
        this.log.debug("StandardConnectionHandle:setupPreparedStatementCache end");
    }

    public void preInvoke() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed");
        }
    }

    public void catchInvoke(SQLException e) throws SQLException {
        throw e;
    }

    public synchronized void close() throws SQLException {
        this.log.debug("StandardConnectionHandle:close");
        this.closed = true;
        Enumeration keys = this.inUse.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.returnToCache(key);
        }
        this.pooledCon.closeEvent();
        this.preparedStatementCache.cleanupAll();
        this.log.debug("StandardConnectionHandle:close preparedStatementCache.size(lru)='" + this.preparedStatementCache.LRUSize() + "' " + "preparedStatementCache.size(cache)='" + this.preparedStatementCache.cacheSize() + "' " + "masterPrepStmtCache.size='" + this.masterPrepStmtCache.size() + "' ");
    }

    void returnToCache(Object key, Connection theCon) {
        Object value = this.inUse.remove(key);
        if (value != null) {
            LRUCache theCache = (LRUCache)this.masterPrepStmtCache.get(theCon.toString());
            theCache.put(key, value);
        }
    }

    void returnToCache(Object key) {
        this.returnToCache(key, this.con);
    }

    synchronized PreparedStatement checkPreparedCache(String sql, int type, int concurrency) throws SQLException {
        this.log.debug("StandardConnectionHandle:checkPreparedCache sql='" + sql + "'");
        PreparedStatement ret = null;
        String lookupKey = sql + type + concurrency;
        if (this.preparedStatementCache != null) {
            Object obj = this.preparedStatementCache.get(lookupKey);
            if (obj != null) {
                ret = (PreparedStatement)obj;
                try {
                    ret.clearParameters();
                }
                catch (SQLException e) {
                    ret = this.createPreparedStatement(sql, type, concurrency);
                }
                this.preparedStatementCache.remove(lookupKey);
                this.inUse.put(lookupKey, ret);
            } else {
                ret = this.createPreparedStatement(sql, type, concurrency);
                this.inUse.put(lookupKey, ret);
            }
        } else {
            ret = this.createPreparedStatement(sql, type, concurrency);
        }
        ret = new StandardPreparedStatement(this, ret, lookupKey);
        return ret;
    }

    protected PreparedStatement createPreparedStatement(String sql, int type, int concurrency) throws SQLException {
        this.log.debug("StandardConnectionHandle:createPreparedStatement type ='" + type + "'");
        if (type == 0) {
            return this.con.prepareStatement(sql);
        }
        return this.con.prepareStatement(sql, type, concurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.log.debug("StandardConnectionHandle:prepareStatement sql='" + sql + "'");
        this.preInvoke();
        try {
            return this.checkPreparedCache(sql, 0, 0);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preInvoke();
        try {
            return this.checkPreparedCache(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preInvoke();
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.catchInvoke(e);
            return null;
        }
    }
}

