/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.NGUnixDomainSocketLibrary;
import com.sun.jna.Platform;
import java.net.InetAddress;

public class NGListeningAddress {
    private final boolean isInet;
    private final boolean isLocal;
    private final InetAddress inetAddress;
    private final int inetPort;
    private final String localAddress;

    public NGListeningAddress(InetAddress inetAddress, int inetPort) {
        this.isInet = true;
        this.isLocal = false;
        this.inetAddress = inetAddress;
        this.inetPort = inetPort;
        this.localAddress = null;
    }

    public NGListeningAddress(String localAddress) {
        this.isInet = false;
        this.isLocal = true;
        this.inetAddress = null;
        this.inetPort = -1;
        this.localAddress = localAddress;
    }

    public boolean isInetAddress() {
        return this.isInet;
    }

    public boolean isLocalAddress() {
        return this.isLocal;
    }

    public InetAddress getInetAddress() {
        if (!this.isInet) {
            throw new IllegalStateException("Family is not INET");
        }
        return this.inetAddress;
    }

    public int getInetPort() {
        if (!this.isInet) {
            throw new IllegalStateException("Family is not INET");
        }
        return this.inetPort;
    }

    public String getLocalAddress() {
        if (!this.isLocal) {
            throw new IllegalStateException("Family is not LOCAL");
        }
        return this.localAddress;
    }

    public String toString() {
        if (this.isInet) {
            if (this.inetAddress != null) {
                return "address " + this.inetAddress + " port " + this.inetPort;
            }
            return "all addresses, port " + this.inetPort;
        }
        return "local socket " + this.localAddress;
    }

    public static void release(String localAddress) {
        if (Platform.isWindows()) {
            return;
        }
        NGUnixDomainSocketLibrary.unlink(localAddress);
    }
}

