/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.dataformat.xml.deser.ElementWrapper;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;

public class XmlTokenStream {
    public static final int XML_START_ELEMENT = 1;
    public static final int XML_END_ELEMENT = 2;
    public static final int XML_ATTRIBUTE_NAME = 3;
    public static final int XML_ATTRIBUTE_VALUE = 4;
    public static final int XML_TEXT = 5;
    public static final int XML_END = 6;
    private static final int REPLAY_START_DUP = 1;
    private static final int REPLAY_END = 2;
    private static final int REPLAY_START_DELAYED = 3;
    protected final XMLStreamReader2 _xmlReader;
    protected final Object _sourceReference;
    protected int _currentState;
    protected int _attributeCount;
    protected int _nextAttributeIndex = 0;
    protected String _localName;
    protected String _namespaceURI;
    protected String _textValue;
    protected int _repeatElement;
    protected ElementWrapper _currentWrapper;
    protected String _nextLocalName;
    protected String _nextNamespaceURI;

    public XmlTokenStream(XMLStreamReader xMLStreamReader, Object object) {
        this._sourceReference = object;
        if (xMLStreamReader.getEventType() != 1) {
            throw new IllegalArgumentException("Invalid XMLStreamReader passed: should be pointing to START_ELEMENT (1), instead got " + xMLStreamReader.getEventType());
        }
        this._xmlReader = Stax2ReaderAdapter.wrapIfNecessary((XMLStreamReader)xMLStreamReader);
        this._currentState = 1;
        this._localName = this._xmlReader.getLocalName();
        this._namespaceURI = this._xmlReader.getNamespaceURI();
        this._attributeCount = this._xmlReader.getAttributeCount();
    }

    public XMLStreamReader2 getXmlReader() {
        return this._xmlReader;
    }

    public int next() throws IOException {
        if (this._repeatElement != 0) {
            this._currentState = this._handleRepeatElement();
            return this._currentState;
        }
        try {
            return this._next();
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
            return -1;
        }
    }

    public void skipEndElement() throws IOException {
        int n = this.next();
        if (n != 2) {
            throw new IOException("Expected END_ELEMENT, got event of type " + n);
        }
    }

    public int getCurrentToken() {
        return this._currentState;
    }

    public String getText() {
        return this._textValue;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public boolean hasAttributes() {
        return this._currentState == 1 && this._attributeCount > 0;
    }

    public void closeCompletely() throws IOException {
        try {
            this._xmlReader.closeCompletely();
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public void close() throws IOException {
        try {
            this._xmlReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    public JsonLocation getCurrentLocation() {
        return this._extractLocation(this._xmlReader.getLocationInfo().getCurrentLocation());
    }

    public JsonLocation getTokenLocation() {
        return this._extractLocation(this._xmlReader.getLocationInfo().getStartLocation());
    }

    protected void repeatStartElement() {
        if (this._currentState != 1) {
            throw new IllegalStateException("Current state not XML_START_ELEMENT (1) but " + this._currentState);
        }
        this._currentWrapper = this._currentWrapper == null ? ElementWrapper.matchingWrapper(this._currentWrapper, this._localName, this._namespaceURI) : ElementWrapper.matchingWrapper(this._currentWrapper.getParent(), this._localName, this._namespaceURI);
        this._repeatElement = 1;
    }

    protected void skipAttributes() {
        if (this._currentState == 3) {
            this._attributeCount = 0;
            this._currentState = 1;
        } else if (this._currentState != 1 && this._currentState != 5) {
            throw new IllegalStateException("Current state not XML_START_ELEMENT or XML_ATTRIBUTE_NAME (1) but " + this._currentState);
        }
    }

    protected String convertToString() throws IOException {
        if (this._currentState != 3 || this._nextAttributeIndex != 0) {
            return null;
        }
        try {
            String string = this._collectUntilTag();
            if (string != null && this._xmlReader.getEventType() == 2) {
                if (this._currentWrapper != null) {
                    this._currentWrapper = this._currentWrapper.getParent();
                }
                this._localName = this._xmlReader.getLocalName();
                this._namespaceURI = this._xmlReader.getNamespaceURI();
                this._attributeCount = 0;
                this._currentState = 5;
                this._textValue = string;
                return string;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
        return null;
    }

    private final int _next() throws XMLStreamException {
        switch (this._currentState) {
            case 4: {
                ++this._nextAttributeIndex;
            }
            case 1: {
                if (this._nextAttributeIndex < this._attributeCount) {
                    this._localName = this._xmlReader.getAttributeLocalName(this._nextAttributeIndex);
                    this._namespaceURI = this._xmlReader.getAttributeNamespace(this._nextAttributeIndex);
                    this._textValue = this._xmlReader.getAttributeValue(this._nextAttributeIndex);
                    this._currentState = 3;
                    return 3;
                }
                String string = this._collectUntilTag();
                if (this._xmlReader.getEventType() == 1) {
                    return this._initStartElement();
                }
                if (string != null) {
                    this._textValue = string;
                    this._currentState = 5;
                    return 5;
                }
                return this._handleEndElement();
            }
            case 3: {
                this._currentState = 4;
                return 4;
            }
            case 5: {
                return this._handleEndElement();
            }
            case 6: {
                return 6;
            }
        }
        switch (this._skipUntilTag()) {
            case 8: {
                this._currentState = 6;
                return 6;
            }
            case 2: {
                return this._handleEndElement();
            }
        }
        return this._initStartElement();
    }

    private final String _collectUntilTag() throws XMLStreamException {
        String string = null;
        block4: while (true) {
            switch (this._xmlReader.next()) {
                case 1: 
                case 2: 
                case 8: {
                    return string;
                }
                case 4: 
                case 12: {
                    if (string == null) {
                        string = this._xmlReader.getText();
                        continue block4;
                    }
                    string = string + this._xmlReader.getText();
                    continue block4;
                }
            }
        }
    }

    private final int _skipUntilTag() throws XMLStreamException {
        while (this._xmlReader.hasNext()) {
            int n = this._xmlReader.next();
            switch (n) {
                case 1: 
                case 2: 
                case 8: {
                    return n;
                }
            }
        }
        throw new IllegalStateException("Expected to find a tag, instead reached end of input");
    }

    private final int _initStartElement() throws XMLStreamException {
        String string = this._xmlReader.getNamespaceURI();
        String string2 = this._xmlReader.getLocalName();
        this._nextAttributeIndex = 0;
        if (this._currentWrapper != null) {
            if (this._currentWrapper.matchesWrapper(string2, string)) {
                this._currentWrapper = this._currentWrapper.intermediateWrapper();
            } else {
                this._localName = this._currentWrapper.getWrapperLocalName();
                this._namespaceURI = this._currentWrapper.getWrapperNamespace();
                this._currentWrapper = this._currentWrapper.getParent();
                this._nextLocalName = string2;
                this._nextNamespaceURI = string;
                this._repeatElement = 3;
                this._currentState = 2;
                return 2;
            }
        }
        this._attributeCount = this._xmlReader.getAttributeCount();
        this._localName = string2;
        this._namespaceURI = string;
        this._currentState = 1;
        return 1;
    }

    protected int _handleRepeatElement() throws IOException {
        int n = this._repeatElement;
        this._repeatElement = 0;
        if (n == 1) {
            this._currentWrapper = this._currentWrapper.intermediateWrapper();
            return 1;
        }
        if (n == 2) {
            this._localName = this._xmlReader.getLocalName();
            this._namespaceURI = this._xmlReader.getNamespaceURI();
            if (this._currentWrapper != null) {
                this._currentWrapper = this._currentWrapper.getParent();
            }
            return 2;
        }
        if (n == 3) {
            if (this._currentWrapper != null) {
                this._currentWrapper = this._currentWrapper.intermediateWrapper();
            }
            this._localName = this._nextLocalName;
            this._namespaceURI = this._nextNamespaceURI;
            this._nextLocalName = null;
            this._nextNamespaceURI = null;
            return 1;
        }
        throw new IllegalStateException("Unrecognized type to repeat: " + n);
    }

    private final int _handleEndElement() {
        if (this._currentWrapper != null) {
            ElementWrapper elementWrapper = this._currentWrapper;
            if (elementWrapper.isMatching()) {
                this._repeatElement = 2;
                this._localName = elementWrapper.getWrapperLocalName();
                this._namespaceURI = elementWrapper.getWrapperNamespace();
                this._currentWrapper = this._currentWrapper.getParent();
            } else {
                this._currentWrapper = this._currentWrapper.getParent();
            }
        }
        this._currentState = 2;
        return 2;
    }

    private JsonLocation _extractLocation(XMLStreamLocation2 xMLStreamLocation2) {
        if (xMLStreamLocation2 == null) {
            return new JsonLocation(this._sourceReference, -1L, -1, -1);
        }
        return new JsonLocation(this._sourceReference, (long)xMLStreamLocation2.getCharacterOffset(), xMLStreamLocation2.getLineNumber(), xMLStreamLocation2.getColumnNumber());
    }
}

