/*
 * (C) Copyright 2016 Fluenda.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package com.fluenda.parcefone.event;

import java.util.Map;

/**
 *  Implements a <i>struct like</i> class that holds headers and extension fields defined in the Common Event Format
 *  maintained by HP Enterprise and used by a number of cyber security solutions.
 */
public abstract class CommonEvent {

    /**
     * @param headers A map containing the  keys and values of headers of CEF event
     * @throws CEFHandlingException when it has issues writing the values of the headers
     *
     */
    public abstract void setHeader(Map<String, Object> headers) throws CEFHandlingException;

    /**
     * @param extensions A map containing the keys and values of extensions of CEF event
     * @throws CEFHandlingException when it has issues populating the extensions
     */
    public abstract void setExtension(Map<String, String> extensions) throws CEFHandlingException;

    /**
     * @return A map containing the keys and values of headers
     * @throws CEFHandlingException when it has issues reading the headers of CEF event
     */
    public abstract Map<String, Object> getHeader() throws CEFHandlingException;

    /**
     * @param populatedOnly Boolean defining if Map should include all fields supported by the <b>supported</b> CEF standard
     * @return A map containing the keys and values of CEF extensions
     * @throws CEFHandlingException when it hits issues (e.g. IllegalAccessException) reading the extensions
     */
    public abstract Map<String, Object> getExtension(boolean populatedOnly) throws CEFHandlingException;
}
