/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import uk.org.openbanking.datamodel.account.BCAFeeChargeCap;
import uk.org.openbanking.datamodel.account.FeeApplicableRange;
import uk.org.openbanking.datamodel.account.OtherApplicationFrequency1;
import uk.org.openbanking.datamodel.account.OtherCalculationFrequency1;
import uk.org.openbanking.datamodel.account.OtherFeeCategoryType;
import uk.org.openbanking.datamodel.account.OtherFeeRateType1;
import uk.org.openbanking.datamodel.account.OtherFeeType1;

@ApiModel(description="Other fees/charges details")
public class BCAFeeChargeDetail {
    @JsonProperty(value="FeeCategory")
    private FeeCategoryEnum feeCategory = null;
    @JsonProperty(value="FeeType")
    private FeeTypeEnum feeType = null;
    @JsonProperty(value="NegotiableIndicator")
    private Boolean negotiableIndicator = null;
    @JsonProperty(value="FeeAmount")
    private String feeAmount = null;
    @JsonProperty(value="FeeRate")
    private String feeRate = null;
    @JsonProperty(value="FeeRateType")
    private FeeRateTypeEnum feeRateType = null;
    @JsonProperty(value="ApplicationFrequency")
    private ApplicationFrequencyEnum applicationFrequency = null;
    @JsonProperty(value="CalculationFrequency")
    private CalculationFrequencyEnum calculationFrequency = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="FeeChargeCap")
    private List<BCAFeeChargeCap> feeChargeCap = null;
    @JsonProperty(value="OtherFeeCategoryType")
    private OtherFeeCategoryType otherFeeCategoryType = null;
    @JsonProperty(value="OtherFeeType")
    private OtherFeeType1 otherFeeType = null;
    @JsonProperty(value="OtherFeeRateType")
    private OtherFeeRateType1 otherFeeRateType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OtherApplicationFrequency1 otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OtherCalculationFrequency1 otherCalculationFrequency = null;
    @JsonProperty(value="FeeApplicableRange")
    private FeeApplicableRange feeApplicableRange = null;

    public BCAFeeChargeDetail feeCategory(FeeCategoryEnum feeCategory) {
        this.feeCategory = feeCategory;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Categorisation of fees and charges into standard categories.")
    public FeeCategoryEnum getFeeCategory() {
        return this.feeCategory;
    }

    public void setFeeCategory(FeeCategoryEnum feeCategory) {
        this.feeCategory = feeCategory;
    }

    public BCAFeeChargeDetail feeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Fee/Charge Type")
    public FeeTypeEnum getFeeType() {
        return this.feeType;
    }

    public void setFeeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
    }

    public BCAFeeChargeDetail negotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
        return this;
    }

    @ApiModelProperty(value="Fee/charge which is usually negotiable rather than a fixed amount")
    public Boolean isNegotiableIndicator() {
        return this.negotiableIndicator;
    }

    public void setNegotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
    }

    public BCAFeeChargeDetail feeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Fee Amount charged for a fee/charge (where it is charged in terms of an amount rather than a rate)")
    public String getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
    }

    public BCAFeeChargeDetail feeRate(String feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Rate charged for Fee/Charge (where it is charged in terms of a rate rather than an amount)")
    public String getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(String feeRate) {
        this.feeRate = feeRate;
    }

    public BCAFeeChargeDetail feeRateType(FeeRateTypeEnum feeRateType) {
        this.feeRateType = feeRateType;
        return this;
    }

    @ApiModelProperty(value="Rate type for Fee/Charge (where it is charged in terms of a rate rather than an amount)")
    public FeeRateTypeEnum getFeeRateType() {
        return this.feeRateType;
    }

    public void setFeeRateType(FeeRateTypeEnum feeRateType) {
        this.feeRateType = feeRateType;
    }

    public BCAFeeChargeDetail applicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="How frequently the fee/charge is applied to the account")
    public ApplicationFrequencyEnum getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public BCAFeeChargeDetail calculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How frequently the fee/charge is calculated")
    public CalculationFrequencyEnum getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public BCAFeeChargeDetail notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public BCAFeeChargeDetail addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the fee/charge details.")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public BCAFeeChargeDetail feeChargeCap(List<BCAFeeChargeCap> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
        return this;
    }

    public BCAFeeChargeDetail addFeeChargeCapItem(BCAFeeChargeCap feeChargeCapItem) {
        if (this.feeChargeCap == null) {
            this.feeChargeCap = new ArrayList<BCAFeeChargeCap>();
        }
        this.feeChargeCap.add(feeChargeCapItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Details about any caps (maximum charges) that apply to a particular or group of fee/charge")
    public List<BCAFeeChargeCap> getFeeChargeCap() {
        return this.feeChargeCap;
    }

    public void setFeeChargeCap(List<BCAFeeChargeCap> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
    }

    public BCAFeeChargeDetail otherFeeCategoryType(OtherFeeCategoryType otherFeeCategoryType) {
        this.otherFeeCategoryType = otherFeeCategoryType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeCategoryType getOtherFeeCategoryType() {
        return this.otherFeeCategoryType;
    }

    public void setOtherFeeCategoryType(OtherFeeCategoryType otherFeeCategoryType) {
        this.otherFeeCategoryType = otherFeeCategoryType;
    }

    public BCAFeeChargeDetail otherFeeType(OtherFeeType1 otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeType1 getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(OtherFeeType1 otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public BCAFeeChargeDetail otherFeeRateType(OtherFeeRateType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeRateType1 getOtherFeeRateType() {
        return this.otherFeeRateType;
    }

    public void setOtherFeeRateType(OtherFeeRateType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
    }

    public BCAFeeChargeDetail otherApplicationFrequency(OtherApplicationFrequency1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherApplicationFrequency1 getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OtherApplicationFrequency1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public BCAFeeChargeDetail otherCalculationFrequency(OtherCalculationFrequency1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherCalculationFrequency1 getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OtherCalculationFrequency1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public BCAFeeChargeDetail feeApplicableRange(FeeApplicableRange feeApplicableRange) {
        this.feeApplicableRange = feeApplicableRange;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public FeeApplicableRange getFeeApplicableRange() {
        return this.feeApplicableRange;
    }

    public void setFeeApplicableRange(FeeApplicableRange feeApplicableRange) {
        this.feeApplicableRange = feeApplicableRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BCAFeeChargeDetail bcAFeeChargeDetail = (BCAFeeChargeDetail)o;
        return Objects.equals((Object)this.feeCategory, (Object)bcAFeeChargeDetail.feeCategory) && Objects.equals((Object)this.feeType, (Object)bcAFeeChargeDetail.feeType) && Objects.equals(this.negotiableIndicator, bcAFeeChargeDetail.negotiableIndicator) && Objects.equals(this.feeAmount, bcAFeeChargeDetail.feeAmount) && Objects.equals(this.feeRate, bcAFeeChargeDetail.feeRate) && Objects.equals((Object)this.feeRateType, (Object)bcAFeeChargeDetail.feeRateType) && Objects.equals((Object)this.applicationFrequency, (Object)bcAFeeChargeDetail.applicationFrequency) && Objects.equals((Object)this.calculationFrequency, (Object)bcAFeeChargeDetail.calculationFrequency) && Objects.equals(this.notes, bcAFeeChargeDetail.notes) && Objects.equals(this.feeChargeCap, bcAFeeChargeDetail.feeChargeCap) && Objects.equals(this.otherFeeCategoryType, bcAFeeChargeDetail.otherFeeCategoryType) && Objects.equals(this.otherFeeType, bcAFeeChargeDetail.otherFeeType) && Objects.equals(this.otherFeeRateType, bcAFeeChargeDetail.otherFeeRateType) && Objects.equals(this.otherApplicationFrequency, bcAFeeChargeDetail.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, bcAFeeChargeDetail.otherCalculationFrequency) && Objects.equals(this.feeApplicableRange, bcAFeeChargeDetail.feeApplicableRange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeCategory, this.feeType, this.negotiableIndicator, this.feeAmount, this.feeRate, this.feeRateType, this.applicationFrequency, this.calculationFrequency, this.notes, this.feeChargeCap, this.otherFeeCategoryType, this.otherFeeType, this.otherFeeRateType, this.otherApplicationFrequency, this.otherCalculationFrequency, this.feeApplicableRange});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BCAFeeChargeDetail {\n");
        sb.append("    feeCategory: ").append(this.toIndentedString((Object)this.feeCategory)).append("\n");
        sb.append("    feeType: ").append(this.toIndentedString((Object)this.feeType)).append("\n");
        sb.append("    negotiableIndicator: ").append(this.toIndentedString(this.negotiableIndicator)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    feeRateType: ").append(this.toIndentedString((Object)this.feeRateType)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    feeChargeCap: ").append(this.toIndentedString(this.feeChargeCap)).append("\n");
        sb.append("    otherFeeCategoryType: ").append(this.toIndentedString(this.otherFeeCategoryType)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("    otherFeeRateType: ").append(this.toIndentedString(this.otherFeeRateType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("    feeApplicableRange: ").append(this.toIndentedString(this.feeApplicableRange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalculationFrequencyEnum {
        ONCLOSING("OnClosing"),
        ONOPENING("OnOpening"),
        CHARGINGPERIOD("ChargingPeriod"),
        DAILY("Daily"),
        PERITEM("PerItem"),
        MONTHLY("Monthly"),
        ONANNIVERSARY("OnAnniversary"),
        OTHER("Other"),
        PERHUNDREDPOUNDS("PerHundredPounds"),
        PERHOUR("PerHour"),
        PEROCCURRENCE("PerOccurrence"),
        PERSHEET("PerSheet"),
        PERTRANSACTION("PerTransaction"),
        PERTRANSACTIONAMOUNT("PerTransactionAmount"),
        PERTRANSACTIONPERCENTAGE("PerTransactionPercentage"),
        QUARTERLY("Quarterly"),
        SIXMONTHLY("SixMonthly"),
        STATEMENTMONTHLY("StatementMonthly"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private CalculationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CalculationFrequencyEnum fromValue(String text) {
            for (CalculationFrequencyEnum b : CalculationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ApplicationFrequencyEnum {
        ONCLOSING("OnClosing"),
        ONOPENING("OnOpening"),
        CHARGINGPERIOD("ChargingPeriod"),
        DAILY("Daily"),
        PERITEM("PerItem"),
        MONTHLY("Monthly"),
        ONANNIVERSARY("OnAnniversary"),
        OTHER("Other"),
        PERHUNDREDPOUNDS("PerHundredPounds"),
        PERHOUR("PerHour"),
        PEROCCURRENCE("PerOccurrence"),
        PERSHEET("PerSheet"),
        PERTRANSACTION("PerTransaction"),
        PERTRANSACTIONAMOUNT("PerTransactionAmount"),
        PERTRANSACTIONPERCENTAGE("PerTransactionPercentage"),
        QUARTERLY("Quarterly"),
        SIXMONTHLY("SixMonthly"),
        STATEMENTMONTHLY("StatementMonthly"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private ApplicationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ApplicationFrequencyEnum fromValue(String text) {
            for (ApplicationFrequencyEnum b : ApplicationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeRateTypeEnum {
        GROSS("Gross"),
        OTHER("Other");

        private String value;

        private FeeRateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeRateTypeEnum fromValue(String text) {
            for (FeeRateTypeEnum b : FeeRateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeTypeEnum {
        OTHER("Other"),
        SERVICECACCOUNTFEE("ServiceCAccountFee"),
        SERVICECACCOUNTFEEMONTHLY("ServiceCAccountFeeMonthly"),
        SERVICECACCOUNTFEEQUARTERLY("ServiceCAccountFeeQuarterly"),
        SERVICECFIXEDTARIFF("ServiceCFixedTariff"),
        SERVICECBUSIDEPACCBREAKAGE("ServiceCBusiDepAccBreakage"),
        SERVICECMINIMUMMONTHLYFEE("ServiceCMinimumMonthlyFee"),
        SERVICECOTHER("ServiceCOther");

        private String value;

        private FeeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeTypeEnum fromValue(String text) {
            for (FeeTypeEnum b : FeeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeCategoryEnum {
        OTHER("Other"),
        SERVICING("Servicing");

        private String value;

        private FeeCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeCategoryEnum fromValue(String text) {
            for (FeeCategoryEnum b : FeeCategoryEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

