/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.CreditInterest1TierBandSet;

@ApiModel(description="Details about the interest that may be payable to the PCA account holders")
public class CreditInterest1 {
    @JsonProperty(value="TierBandSet")
    private List<CreditInterest1TierBandSet> tierBandSet = new ArrayList<CreditInterest1TierBandSet>();

    public CreditInterest1 tierBandSet(List<CreditInterest1TierBandSet> tierBandSet) {
        this.tierBandSet = tierBandSet;
        return this;
    }

    public CreditInterest1 addTierBandSetItem(CreditInterest1TierBandSet tierBandSetItem) {
        this.tierBandSet.add(tierBandSetItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="The group of tiers or bands for which credit interest can be applied.")
    public List<CreditInterest1TierBandSet> getTierBandSet() {
        return this.tierBandSet;
    }

    public void setTierBandSet(List<CreditInterest1TierBandSet> tierBandSet) {
        this.tierBandSet = tierBandSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditInterest1 creditInterest1 = (CreditInterest1)o;
        return Objects.equals(this.tierBandSet, creditInterest1.tierBandSet);
    }

    public int hashCode() {
        return Objects.hash(this.tierBandSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditInterest1 {\n");
        sb.append("    tierBandSet: ").append(this.toIndentedString(this.tierBandSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

