/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OtherApplicationFrequency;
import uk.org.openbanking.datamodel.account.OtherBankInterestType;
import uk.org.openbanking.datamodel.account.OtherCalculationFrequency;

@ApiModel(description="Tier Band Details")
public class CreditInterest1TierBand {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMinimum")
    private String tierValueMinimum = null;
    @JsonProperty(value="TierValueMaximum")
    private String tierValueMaximum = null;
    @JsonProperty(value="CalculationFrequency")
    private CalculationFrequencyEnum calculationFrequency = null;
    @JsonProperty(value="ApplicationFrequency")
    private ApplicationFrequencyEnum applicationFrequency = null;
    @JsonProperty(value="DepositInterestAppliedCoverage")
    private DepositInterestAppliedCoverageEnum depositInterestAppliedCoverage = null;
    @JsonProperty(value="FixedVariableInterestRateType")
    private FixedVariableInterestRateTypeEnum fixedVariableInterestRateType = null;
    @JsonProperty(value="AER")
    private String AER = null;
    @JsonProperty(value="BankInterestRateType")
    private BankInterestRateTypeEnum bankInterestRateType = null;
    @JsonProperty(value="BankInterestRate")
    private String bankInterestRate = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherBankInterestType")
    private OtherBankInterestType otherBankInterestType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OtherApplicationFrequency otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OtherCalculationFrequency otherCalculationFrequency = null;

    public CreditInterest1TierBand identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a PCA.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public CreditInterest1TierBand tierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="Minimum deposit value for which the credit interest tier applies.")
    public String getTierValueMinimum() {
        return this.tierValueMinimum;
    }

    public void setTierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
    }

    public CreditInterest1TierBand tierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Maximum deposit value for which the credit interest tier applies.")
    public String getTierValueMaximum() {
        return this.tierValueMaximum;
    }

    public void setTierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
    }

    public CreditInterest1TierBand calculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How often is credit interest calculated for the account.")
    public CalculationFrequencyEnum getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public CreditInterest1TierBand applicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="How often is interest applied to the PCA for this tier/band i.e. how often the financial institution pays accumulated interest to the customer's PCA.")
    public ApplicationFrequencyEnum getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public CreditInterest1TierBand depositInterestAppliedCoverage(DepositInterestAppliedCoverageEnum depositInterestAppliedCoverage) {
        this.depositInterestAppliedCoverage = depositInterestAppliedCoverage;
        return this;
    }

    @ApiModelProperty(value="Amount on which Interest applied.")
    public DepositInterestAppliedCoverageEnum getDepositInterestAppliedCoverage() {
        return this.depositInterestAppliedCoverage;
    }

    public void setDepositInterestAppliedCoverage(DepositInterestAppliedCoverageEnum depositInterestAppliedCoverage) {
        this.depositInterestAppliedCoverage = depositInterestAppliedCoverage;
    }

    public CreditInterest1TierBand fixedVariableInterestRateType(FixedVariableInterestRateTypeEnum fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Type of interest rate, Fixed or Variable")
    public FixedVariableInterestRateTypeEnum getFixedVariableInterestRateType() {
        return this.fixedVariableInterestRateType;
    }

    public void setFixedVariableInterestRateType(FixedVariableInterestRateTypeEnum fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
    }

    public CreditInterest1TierBand AER(String AER) {
        this.AER = AER;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="The annual equivalent rate (AER) is interest that is calculated under the assumption that any interest paid is combined with the original balance and the next interest payment will be based on the slightly higher account balance. Overall, this means that interest can be compounded several times in a year depending on the number of times that interest payments are made.   Read more: Annual Equivalent Rate (AER) http://www.investopedia.com/terms/a/aer.asp#ixzz4gfR7IO1A")
    public String getAER() {
        return this.AER;
    }

    public void setAER(String AER) {
        this.AER = AER;
    }

    public CreditInterest1TierBand bankInterestRateType(BankInterestRateTypeEnum bankInterestRateType) {
        this.bankInterestRateType = bankInterestRateType;
        return this;
    }

    @ApiModelProperty(value="Interest rate types, other than AER, which financial institutions may use to describe the annual interest rate payable to the PCA.")
    public BankInterestRateTypeEnum getBankInterestRateType() {
        return this.bankInterestRateType;
    }

    public void setBankInterestRateType(BankInterestRateTypeEnum bankInterestRateType) {
        this.bankInterestRateType = bankInterestRateType;
    }

    public CreditInterest1TierBand bankInterestRate(String bankInterestRate) {
        this.bankInterestRate = bankInterestRate;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Bank Interest for the PCA product")
    public String getBankInterestRate() {
        return this.bankInterestRate;
    }

    public void setBankInterestRate(String bankInterestRate) {
        this.bankInterestRate = bankInterestRate;
    }

    public CreditInterest1TierBand notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public CreditInterest1TierBand addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier Band details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public CreditInterest1TierBand otherBankInterestType(OtherBankInterestType otherBankInterestType) {
        this.otherBankInterestType = otherBankInterestType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherBankInterestType getOtherBankInterestType() {
        return this.otherBankInterestType;
    }

    public void setOtherBankInterestType(OtherBankInterestType otherBankInterestType) {
        this.otherBankInterestType = otherBankInterestType;
    }

    public CreditInterest1TierBand otherApplicationFrequency(OtherApplicationFrequency otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherApplicationFrequency getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OtherApplicationFrequency otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public CreditInterest1TierBand otherCalculationFrequency(OtherCalculationFrequency otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherCalculationFrequency getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OtherCalculationFrequency otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditInterest1TierBand creditInterest1TierBand = (CreditInterest1TierBand)o;
        return Objects.equals(this.identification, creditInterest1TierBand.identification) && Objects.equals(this.tierValueMinimum, creditInterest1TierBand.tierValueMinimum) && Objects.equals(this.tierValueMaximum, creditInterest1TierBand.tierValueMaximum) && Objects.equals((Object)this.calculationFrequency, (Object)creditInterest1TierBand.calculationFrequency) && Objects.equals((Object)this.applicationFrequency, (Object)creditInterest1TierBand.applicationFrequency) && Objects.equals((Object)this.depositInterestAppliedCoverage, (Object)creditInterest1TierBand.depositInterestAppliedCoverage) && Objects.equals((Object)this.fixedVariableInterestRateType, (Object)creditInterest1TierBand.fixedVariableInterestRateType) && Objects.equals(this.AER, creditInterest1TierBand.AER) && Objects.equals((Object)this.bankInterestRateType, (Object)creditInterest1TierBand.bankInterestRateType) && Objects.equals(this.bankInterestRate, creditInterest1TierBand.bankInterestRate) && Objects.equals(this.notes, creditInterest1TierBand.notes) && Objects.equals(this.otherBankInterestType, creditInterest1TierBand.otherBankInterestType) && Objects.equals(this.otherApplicationFrequency, creditInterest1TierBand.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, creditInterest1TierBand.otherCalculationFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMinimum, this.tierValueMaximum, this.calculationFrequency, this.applicationFrequency, this.depositInterestAppliedCoverage, this.fixedVariableInterestRateType, this.AER, this.bankInterestRateType, this.bankInterestRate, this.notes, this.otherBankInterestType, this.otherApplicationFrequency, this.otherCalculationFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditInterest1TierBand {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMinimum: ").append(this.toIndentedString(this.tierValueMinimum)).append("\n");
        sb.append("    tierValueMaximum: ").append(this.toIndentedString(this.tierValueMaximum)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    depositInterestAppliedCoverage: ").append(this.toIndentedString((Object)this.depositInterestAppliedCoverage)).append("\n");
        sb.append("    fixedVariableInterestRateType: ").append(this.toIndentedString((Object)this.fixedVariableInterestRateType)).append("\n");
        sb.append("    AER: ").append(this.toIndentedString(this.AER)).append("\n");
        sb.append("    bankInterestRateType: ").append(this.toIndentedString((Object)this.bankInterestRateType)).append("\n");
        sb.append("    bankInterestRate: ").append(this.toIndentedString(this.bankInterestRate)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherBankInterestType: ").append(this.toIndentedString(this.otherBankInterestType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BankInterestRateTypeEnum {
        LINKEDBASERATE("LinkedBaseRate"),
        GROSS("Gross"),
        NET("Net"),
        OTHER("Other");

        private String value;

        private BankInterestRateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BankInterestRateTypeEnum fromValue(String text) {
            for (BankInterestRateTypeEnum b : BankInterestRateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FixedVariableInterestRateTypeEnum {
        FIXED("Fixed"),
        VARIABLE("Variable");

        private String value;

        private FixedVariableInterestRateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FixedVariableInterestRateTypeEnum fromValue(String text) {
            for (FixedVariableInterestRateTypeEnum b : FixedVariableInterestRateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DepositInterestAppliedCoverageEnum {
        TIERED("Tiered"),
        WHOLE("Whole");

        private String value;

        private DepositInterestAppliedCoverageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DepositInterestAppliedCoverageEnum fromValue(String text) {
            for (DepositInterestAppliedCoverageEnum b : DepositInterestAppliedCoverageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ApplicationFrequencyEnum {
        PERACADEMICTERM("PerAcademicTerm"),
        DAILY("Daily"),
        HALFYEARLY("HalfYearly"),
        MONTHLY("Monthly"),
        OTHER("Other"),
        QUARTERLY("Quarterly"),
        PERSTATEMENTDATE("PerStatementDate"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private ApplicationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ApplicationFrequencyEnum fromValue(String text) {
            for (ApplicationFrequencyEnum b : ApplicationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum CalculationFrequencyEnum {
        PERACADEMICTERM("PerAcademicTerm"),
        DAILY("Daily"),
        HALFYEARLY("HalfYearly"),
        MONTHLY("Monthly"),
        OTHER("Other"),
        QUARTERLY("Quarterly"),
        PERSTATEMENTDATE("PerStatementDate"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private CalculationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CalculationFrequencyEnum fromValue(String text) {
            for (CalculationFrequencyEnum b : CalculationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

