/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.CreditInterestTierBand;

@ApiModel(description="The group of tiers or bands for which credit interest can be applied.")
public class CreditInterestTierBandSet {
    @JsonProperty(value="TierBandMethod")
    private TierBandMethodEnum tierBandMethod = null;
    @JsonProperty(value="CalculationMethod")
    private CalculationMethodEnum calculationMethod = null;
    @JsonProperty(value="Destination")
    private DestinationEnum destination = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="TierBand")
    private List<CreditInterestTierBand> tierBand = new ArrayList<CreditInterestTierBand>();

    public CreditInterestTierBandSet tierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The methodology of how credit interest is paid/applied. It can be:-  1. Banded Interest rates are banded. i.e. Increasing rate on whole balance as balance increases.  2. Tiered Interest rates are tiered. i.e. increasing rate for each tier as balance increases, but interest paid on tier fixed for that tier and not on whole balance.  3. Whole The same interest rate is applied irrespective of the BCA balance")
    public TierBandMethodEnum getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public CreditInterestTierBandSet calculationMethod(CalculationMethodEnum calculationMethod) {
        this.calculationMethod = calculationMethod;
        return this;
    }

    @ApiModelProperty(value="Methods of calculating interest")
    public CalculationMethodEnum getCalculationMethod() {
        return this.calculationMethod;
    }

    public void setCalculationMethod(CalculationMethodEnum calculationMethod) {
        this.calculationMethod = calculationMethod;
    }

    public CreditInterestTierBandSet destination(DestinationEnum destination) {
        this.destination = destination;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Describes whether accrued interest is payable only to the BCA or to another bank account")
    public DestinationEnum getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationEnum destination) {
        this.destination = destination;
    }

    public CreditInterestTierBandSet notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public CreditInterestTierBandSet addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier Band Set details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public CreditInterestTierBandSet tierBand(List<CreditInterestTierBand> tierBand) {
        this.tierBand = tierBand;
        return this;
    }

    public CreditInterestTierBandSet addTierBandItem(CreditInterestTierBand tierBandItem) {
        this.tierBand.add(tierBandItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="Tier Band Details")
    public List<CreditInterestTierBand> getTierBand() {
        return this.tierBand;
    }

    public void setTierBand(List<CreditInterestTierBand> tierBand) {
        this.tierBand = tierBand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditInterestTierBandSet creditInterestTierBandSet = (CreditInterestTierBandSet)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)creditInterestTierBandSet.tierBandMethod) && Objects.equals((Object)this.calculationMethod, (Object)creditInterestTierBandSet.calculationMethod) && Objects.equals((Object)this.destination, (Object)creditInterestTierBandSet.destination) && Objects.equals(this.notes, creditInterestTierBandSet.notes) && Objects.equals(this.tierBand, creditInterestTierBandSet.tierBand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.calculationMethod, this.destination, this.notes, this.tierBand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditInterestTierBandSet {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    calculationMethod: ").append(this.toIndentedString((Object)this.calculationMethod)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString((Object)this.destination)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    tierBand: ").append(this.toIndentedString(this.tierBand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DestinationEnum {
        PAYAWAY("PayAway"),
        SELFCREDIT("SelfCredit");

        private String value;

        private DestinationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DestinationEnum fromValue(String text) {
            for (DestinationEnum b : DestinationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum CalculationMethodEnum {
        COMPOUND("Compound"),
        SIMPLEINTEREST("SimpleInterest");

        private String value;

        private CalculationMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CalculationMethodEnum fromValue(String text) {
            for (CalculationMethodEnum b : CalculationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TierBandMethodEnum {
        BANDED("Banded"),
        TIERED("Tiered"),
        WHOLE("Whole");

        private String value;

        private TierBandMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TierBandMethodEnum fromValue(String text) {
            for (TierBandMethodEnum b : TierBandMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

