/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification2;
import uk.org.openbanking.datamodel.account.OBCashAccount1;

@ApiModel(description="Account")
public class OBAccount1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="Currency")
    private String currency = null;
    @JsonProperty(value="Nickname")
    private String nickname = null;
    @JsonProperty(value="Account")
    private OBCashAccount1 account = null;
    @JsonProperty(value="Servicer")
    private OBBranchAndFinancialInstitutionIdentification2 servicer = null;

    public OBAccount1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique and immutable identifier used to identify the account resource. This identifier has no meaning to the account owner.")
    @NotNull
    @Size(min=1, max=40)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBAccount1 currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="Identification of the currency in which the account is held.  Usage: Currency should only be used in case one and the same account number covers several currencies and the initiating party needs to identify which currency needs to be used for settlement on the account.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public OBAccount1 nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(value="The nickname of the account, assigned by the account owner in order to provide an additional means of identification of the account.")
    @Size(min=1, max=70)
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public OBAccount1 account(OBCashAccount1 account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount1 getAccount() {
        return this.account;
    }

    public void setAccount(OBCashAccount1 account) {
        this.account = account;
    }

    public OBAccount1 servicer(OBBranchAndFinancialInstitutionIdentification2 servicer) {
        this.servicer = servicer;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getServicer() {
        return this.servicer;
    }

    public void setServicer(OBBranchAndFinancialInstitutionIdentification2 servicer) {
        this.servicer = servicer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBAccount1 account = (OBAccount1)o;
        return Objects.equals(this.accountId, account.accountId) && Objects.equals(this.currency, account.currency) && Objects.equals(this.nickname, account.nickname) && Objects.equals(this.account, account.account) && Objects.equals(this.servicer, account.servicer);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.currency, this.nickname, this.account, this.servicer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    servicer: ").append(this.toIndentedString(this.servicer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

