/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBAccount3Account;
import uk.org.openbanking.datamodel.account.OBAccountStatus1Code;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification50;
import uk.org.openbanking.datamodel.account.OBExternalAccountSubType1Code;
import uk.org.openbanking.datamodel.account.OBExternalAccountType1Code;

@ApiModel(description="Unambiguous identification of the account to which credit and debit entries are made.")
public class OBAccount4 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="Status")
    private OBAccountStatus1Code status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private String statusUpdateDateTime = null;
    @JsonProperty(value="Currency")
    private String currency = null;
    @JsonProperty(value="AccountType")
    private OBExternalAccountType1Code accountType = null;
    @JsonProperty(value="AccountSubType")
    private OBExternalAccountSubType1Code accountSubType = null;
    @JsonProperty(value="Description")
    private String description = null;
    @JsonProperty(value="Nickname")
    private String nickname = null;
    @JsonProperty(value="Account")
    private List<OBAccount3Account> account = null;
    @JsonProperty(value="Servicer")
    private OBBranchAndFinancialInstitutionIdentification50 servicer = null;

    public OBAccount4 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBAccount4 status(OBAccountStatus1Code status) {
        this.status = status;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBAccountStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBAccountStatus1Code status) {
        this.status = status;
    }

    public OBAccount4 statusUpdateDateTime(String statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @ApiModelProperty(value="")
    public String getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(String statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBAccount4 currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    @ApiModelProperty(required=true, value="")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public OBAccount4 accountType(OBExternalAccountType1Code accountType) {
        this.accountType = accountType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalAccountType1Code getAccountType() {
        return this.accountType;
    }

    public void setAccountType(OBExternalAccountType1Code accountType) {
        this.accountType = accountType;
    }

    public OBAccount4 accountSubType(OBExternalAccountSubType1Code accountSubType) {
        this.accountSubType = accountSubType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalAccountSubType1Code getAccountSubType() {
        return this.accountSubType;
    }

    public void setAccountSubType(OBExternalAccountSubType1Code accountSubType) {
        this.accountSubType = accountSubType;
    }

    public OBAccount4 description(String description) {
        this.description = description;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OBAccount4 nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public OBAccount4 account(List<OBAccount3Account> account) {
        this.account = account;
        return this;
    }

    public OBAccount4 addAccountItem(OBAccount3Account accountItem) {
        if (this.account == null) {
            this.account = new ArrayList<OBAccount3Account>();
        }
        this.account.add(accountItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBAccount3Account> getAccount() {
        return this.account;
    }

    public void setAccount(List<OBAccount3Account> account) {
        this.account = account;
    }

    public OBAccount4 servicer(OBBranchAndFinancialInstitutionIdentification50 servicer) {
        this.servicer = servicer;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification50 getServicer() {
        return this.servicer;
    }

    public void setServicer(OBBranchAndFinancialInstitutionIdentification50 servicer) {
        this.servicer = servicer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBAccount4 obAccount4 = (OBAccount4)o;
        return Objects.equals(this.accountId, obAccount4.accountId) && Objects.equals((Object)this.status, (Object)obAccount4.status) && Objects.equals(this.statusUpdateDateTime, obAccount4.statusUpdateDateTime) && Objects.equals(this.currency, obAccount4.currency) && Objects.equals((Object)this.accountType, (Object)obAccount4.accountType) && Objects.equals((Object)this.accountSubType, (Object)obAccount4.accountSubType) && Objects.equals(this.description, obAccount4.description) && Objects.equals(this.nickname, obAccount4.nickname) && Objects.equals(this.account, obAccount4.account) && Objects.equals(this.servicer, obAccount4.servicer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.status, this.statusUpdateDateTime, this.currency, this.accountType, this.accountSubType, this.description, this.nickname, this.account, this.servicer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBAccount4 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    accountSubType: ").append(this.toIndentedString((Object)this.accountSubType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    servicer: ").append(this.toIndentedString(this.servicer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

