/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBBCAData1FeeChargeCap;
import uk.org.openbanking.datamodel.account.OBBCAData1FeeChargeDetail;
import uk.org.openbanking.datamodel.account.OtherTariffType;

@ApiModel(description="Contains details of fees and charges which are not associated with either Overdraft or features/benefits")
public class OBBCAData1OtherFeesCharges {
    @JsonProperty(value="TariffType")
    private TariffTypeEnum tariffType = null;
    @JsonProperty(value="TariffName")
    private String tariffName = null;
    @JsonProperty(value="OtherTariffType")
    private OtherTariffType otherTariffType = null;
    @JsonProperty(value="FeeChargeDetail")
    private List<OBBCAData1FeeChargeDetail> feeChargeDetail = new ArrayList<OBBCAData1FeeChargeDetail>();
    @JsonProperty(value="FeeChargeCap")
    private List<OBBCAData1FeeChargeCap> feeChargeCap = null;

    public OBBCAData1OtherFeesCharges tariffType(TariffTypeEnum tariffType) {
        this.tariffType = tariffType;
        return this;
    }

    @ApiModelProperty(value="TariffType which defines the fee and charges.")
    public TariffTypeEnum getTariffType() {
        return this.tariffType;
    }

    public void setTariffType(TariffTypeEnum tariffType) {
        this.tariffType = tariffType;
    }

    public OBBCAData1OtherFeesCharges tariffName(String tariffName) {
        this.tariffName = tariffName;
        return this;
    }

    @Size(min=1, max=350)
    @ApiModelProperty(value="Name of the tariff")
    public String getTariffName() {
        return this.tariffName;
    }

    public void setTariffName(String tariffName) {
        this.tariffName = tariffName;
    }

    public OBBCAData1OtherFeesCharges otherTariffType(OtherTariffType otherTariffType) {
        this.otherTariffType = otherTariffType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherTariffType getOtherTariffType() {
        return this.otherTariffType;
    }

    public void setOtherTariffType(OtherTariffType otherTariffType) {
        this.otherTariffType = otherTariffType;
    }

    public OBBCAData1OtherFeesCharges feeChargeDetail(List<OBBCAData1FeeChargeDetail> feeChargeDetail) {
        this.feeChargeDetail = feeChargeDetail;
        return this;
    }

    public OBBCAData1OtherFeesCharges addFeeChargeDetailItem(OBBCAData1FeeChargeDetail feeChargeDetailItem) {
        this.feeChargeDetail.add(feeChargeDetailItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="Other fees/charges details")
    public List<OBBCAData1FeeChargeDetail> getFeeChargeDetail() {
        return this.feeChargeDetail;
    }

    public void setFeeChargeDetail(List<OBBCAData1FeeChargeDetail> feeChargeDetail) {
        this.feeChargeDetail = feeChargeDetail;
    }

    public OBBCAData1OtherFeesCharges feeChargeCap(List<OBBCAData1FeeChargeCap> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
        return this;
    }

    public OBBCAData1OtherFeesCharges addFeeChargeCapItem(OBBCAData1FeeChargeCap feeChargeCapItem) {
        if (this.feeChargeCap == null) {
            this.feeChargeCap = new ArrayList<OBBCAData1FeeChargeCap>();
        }
        this.feeChargeCap.add(feeChargeCapItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Details about any caps (maximum charges) that apply to a particular or group of fee/charge")
    public List<OBBCAData1FeeChargeCap> getFeeChargeCap() {
        return this.feeChargeCap;
    }

    public void setFeeChargeCap(List<OBBCAData1FeeChargeCap> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBBCAData1OtherFeesCharges obBCAData1OtherFeesCharges = (OBBCAData1OtherFeesCharges)o;
        return Objects.equals((Object)this.tariffType, (Object)obBCAData1OtherFeesCharges.tariffType) && Objects.equals(this.tariffName, obBCAData1OtherFeesCharges.tariffName) && Objects.equals(this.otherTariffType, obBCAData1OtherFeesCharges.otherTariffType) && Objects.equals(this.feeChargeDetail, obBCAData1OtherFeesCharges.feeChargeDetail) && Objects.equals(this.feeChargeCap, obBCAData1OtherFeesCharges.feeChargeCap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tariffType, this.tariffName, this.otherTariffType, this.feeChargeDetail, this.feeChargeCap});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBBCAData1OtherFeesCharges {\n");
        sb.append("    tariffType: ").append(this.toIndentedString((Object)this.tariffType)).append("\n");
        sb.append("    tariffName: ").append(this.toIndentedString(this.tariffName)).append("\n");
        sb.append("    otherTariffType: ").append(this.toIndentedString(this.otherTariffType)).append("\n");
        sb.append("    feeChargeDetail: ").append(this.toIndentedString(this.feeChargeDetail)).append("\n");
        sb.append("    feeChargeCap: ").append(this.toIndentedString(this.feeChargeCap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TariffTypeEnum {
        ELECTRONIC("Electronic"),
        MIXED("Mixed"),
        OTHER("Other");

        private String value;

        private TariffTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TariffTypeEnum fromValue(String text) {
            for (TariffTypeEnum b : TariffTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

