/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBCAProductSegment1Code;
import uk.org.openbanking.datamodel.account.OBPeriod1Code;

@Validated
public class OBBCAProductDetails1 {
    @JsonProperty(value="Segment")
    @Valid
    private List<OBBCAProductSegment1Code> segment = null;
    @JsonProperty(value="FeeFreeLength")
    private Float feeFreeLength = null;
    @JsonProperty(value="FeeFreeLengthPeriod")
    private OBPeriod1Code feeFreeLengthPeriod = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;

    public OBBCAProductDetails1 segment(List<OBBCAProductSegment1Code> segment) {
        this.segment = segment;
        return this;
    }

    public OBBCAProductDetails1 addSegmentItem(OBBCAProductSegment1Code segmentItem) {
        if (this.segment == null) {
            this.segment = new ArrayList<OBBCAProductSegment1Code>();
        }
        this.segment.add(segmentItem);
        return this;
    }

    @ApiModelProperty(value="Market segmentation is a marketing term referring to the aggregating of prospective buyers into groups, or segments, that have common needs and respond similarly to a marketing action. Market segmentation enables companies to target different categories of consumers who perceive the full value of certain products and services differently from one another.  Read more: Market Segmentation http://www.investopedia.com/terms/m/marketsegmentation.asp#ixzz4gfEEalTd  With respect to BCA products, they are segmented in relation to different markets that they wish to focus on. ")
    public List<OBBCAProductSegment1Code> getSegment() {
        return this.segment;
    }

    public void setSegment(List<OBBCAProductSegment1Code> segment) {
        this.segment = segment;
    }

    public OBBCAProductDetails1 feeFreeLength(Float feeFreeLength) {
        this.feeFreeLength = feeFreeLength;
        return this;
    }

    @ApiModelProperty(value="The length/duration of the fee free period")
    public Float getFeeFreeLength() {
        return this.feeFreeLength;
    }

    public void setFeeFreeLength(Float feeFreeLength) {
        this.feeFreeLength = feeFreeLength;
    }

    public OBBCAProductDetails1 feeFreeLengthPeriod(OBPeriod1Code feeFreeLengthPeriod) {
        this.feeFreeLengthPeriod = feeFreeLengthPeriod;
        return this;
    }

    @ApiModelProperty(value="The unit of period (days, weeks, months etc.) of the promotional length")
    public OBPeriod1Code getFeeFreeLengthPeriod() {
        return this.feeFreeLengthPeriod;
    }

    public void setFeeFreeLengthPeriod(OBPeriod1Code feeFreeLengthPeriod) {
        this.feeFreeLengthPeriod = feeFreeLengthPeriod;
    }

    public OBBCAProductDetails1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBBCAProductDetails1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Core product details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBBCAProductDetails1 productDetails1 = (OBBCAProductDetails1)o;
        return Objects.equals(this.segment, productDetails1.segment) && Objects.equals(this.feeFreeLength, productDetails1.feeFreeLength) && Objects.equals((Object)this.feeFreeLengthPeriod, (Object)productDetails1.feeFreeLengthPeriod) && Objects.equals(this.notes, productDetails1.notes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.segment, this.feeFreeLength, this.feeFreeLengthPeriod, this.notes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBBCAProductDetails1 {\n");
        sb.append("    segment: ").append(this.toIndentedString(this.segment)).append("\n");
        sb.append("    feeFreeLength: ").append(this.toIndentedString(this.feeFreeLength)).append("\n");
        sb.append("    feeFreeLengthPeriod: ").append(this.toIndentedString((Object)this.feeFreeLengthPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

