/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification2;
import uk.org.openbanking.datamodel.account.OBCashAccount1;

@ApiModel(description="Beneficiary")
public class OBBeneficiary1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="BeneficiaryId")
    private String beneficiaryId = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="Servicer")
    private OBBranchAndFinancialInstitutionIdentification2 servicer = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount1 creditorAccount = null;

    public OBBeneficiary1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="A unique and immutable identifier used to identify the account resource. This identifier has no meaning to the account owner.")
    @Size(min=1, max=40)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBBeneficiary1 beneficiaryId(String beneficiaryId) {
        this.beneficiaryId = beneficiaryId;
        return this;
    }

    @ApiModelProperty(value="A unique and immutable identifier used to identify the beneficiary resource. This identifier has no meaning to the account owner.")
    @Size(min=1, max=40)
    public String getBeneficiaryId() {
        return this.beneficiaryId;
    }

    public void setBeneficiaryId(String beneficiaryId) {
        this.beneficiaryId = beneficiaryId;
    }

    public OBBeneficiary1 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    @Size(min=1, max=35)
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBBeneficiary1 servicer(OBBranchAndFinancialInstitutionIdentification2 servicer) {
        this.servicer = servicer;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getServicer() {
        return this.servicer;
    }

    public void setServicer(OBBranchAndFinancialInstitutionIdentification2 servicer) {
        this.servicer = servicer;
    }

    public OBBeneficiary1 creditorAccount(OBCashAccount1 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount1 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount1 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBBeneficiary1 beneficiary = (OBBeneficiary1)o;
        return Objects.equals(this.accountId, beneficiary.accountId) && Objects.equals(this.beneficiaryId, beneficiary.beneficiaryId) && Objects.equals(this.reference, beneficiary.reference) && Objects.equals(this.servicer, beneficiary.servicer) && Objects.equals(this.creditorAccount, beneficiary.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.beneficiaryId, this.reference, this.servicer, this.creditorAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Beneficiary {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    beneficiaryId: ").append(this.toIndentedString(this.beneficiaryId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    servicer: ").append(this.toIndentedString(this.servicer)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

