/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBPostalAddress6;

@ApiModel(description="Financial institution servicing an account for the debtor.")
@Validated
public class OBBranchAndFinancialInstitutionIdentification3 {
    @JsonProperty(value="SchemeName")
    private String schemeName = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="PostalAddress")
    private OBPostalAddress6 postalAddress = null;

    public OBBranchAndFinancialInstitutionIdentification3 schemeName(String schemeName) {
        this.schemeName = schemeName;
        return this;
    }

    @ApiModelProperty(value="Name of the identification scheme, in a coded form as published in an external list.")
    @Size(min=1, max=40)
    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public OBBranchAndFinancialInstitutionIdentification3 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(value="Unique and unambiguous identification of a financial institution or a branch of a financial institution.")
    @Size(min=1, max=35)
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBBranchAndFinancialInstitutionIdentification3 name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name by which an agent is known and which is usually used to identify that agent.")
    @Size(min=1, max=140)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBBranchAndFinancialInstitutionIdentification3 postalAddress(OBPostalAddress6 postalAddress) {
        this.postalAddress = postalAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPostalAddress6 getPostalAddress() {
        return this.postalAddress;
    }

    public void setPostalAddress(OBPostalAddress6 postalAddress) {
        this.postalAddress = postalAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBBranchAndFinancialInstitutionIdentification3 obBranchAndFinancialInstitutionIdentification3 = (OBBranchAndFinancialInstitutionIdentification3)o;
        return Objects.equals(this.schemeName, obBranchAndFinancialInstitutionIdentification3.schemeName) && Objects.equals(this.identification, obBranchAndFinancialInstitutionIdentification3.identification) && Objects.equals(this.name, obBranchAndFinancialInstitutionIdentification3.name) && Objects.equals(this.postalAddress, obBranchAndFinancialInstitutionIdentification3.postalAddress);
    }

    public int hashCode() {
        return Objects.hash(this.schemeName, this.identification, this.name, this.postalAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBBranchAndFinancialInstitutionIdentification3 {\n");
        sb.append("    schemeName: ").append(this.toIndentedString(this.schemeName)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    postalAddress: ").append(this.toIndentedString(this.postalAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

