/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.payment.OBExternalAccountIdentification2Code;

@ApiModel(description="Provides the details to identify an account.")
public class OBCashAccount1 {
    @JsonProperty(value="SchemeName")
    private OBExternalAccountIdentification2Code schemeName = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="SecondaryIdentification")
    private String secondaryIdentification = null;

    public OBCashAccount1 schemeName(OBExternalAccountIdentification2Code schemeName) {
        this.schemeName = schemeName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the identification scheme, in a coded form as published in an external list.")
    @NotNull
    public OBExternalAccountIdentification2Code getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(OBExternalAccountIdentification2Code schemeName) {
        this.schemeName = schemeName;
    }

    public OBCashAccount1 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(required=true, value="Identification assigned by an institution to identify an account. This identification is known by the account owner.")
    @NotNull
    @Size(min=1, max=34)
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBCashAccount1 name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the account, as assigned by the account servicing institution, in agreement with the account owner in order to provide an additional means of identification of the account. Usage: The account name is different from the account owner name. The account name is used in certain user communities to provide a means of identifying the account, in addition to the account owner's identity and the account number.")
    @Size(min=1, max=70)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBCashAccount1 secondaryIdentification(String secondaryIdentification) {
        this.secondaryIdentification = secondaryIdentification;
        return this;
    }

    @ApiModelProperty(value="This is secondary identification of the account, as assigned by the account servicing institution.  This can be used by building societies to additionally identify accounts with a roll number (in addition to a sort code and account number combination).")
    @Size(min=1, max=34)
    public String getSecondaryIdentification() {
        return this.secondaryIdentification;
    }

    public void setSecondaryIdentification(String secondaryIdentification) {
        this.secondaryIdentification = secondaryIdentification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCashAccount1 data2Account = (OBCashAccount1)o;
        return Objects.equals((Object)this.schemeName, (Object)data2Account.schemeName) && Objects.equals(this.identification, data2Account.identification) && Objects.equals(this.name, data2Account.name) && Objects.equals(this.secondaryIdentification, data2Account.secondaryIdentification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemeName, this.identification, this.name, this.secondaryIdentification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Data2Account {\n");
        sb.append("    schemeName: ").append(this.toIndentedString((Object)this.schemeName)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    secondaryIdentification: ").append(this.toIndentedString(this.secondaryIdentification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

