/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="Provides the details to identify the beneficiary account.")
public class OBCashAccount5 {
    @JsonProperty(value="SchemeName")
    private String schemeName = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="SecondaryIdentification")
    private String secondaryIdentification = null;

    public OBCashAccount5 schemeName(String schemeName) {
        this.schemeName = schemeName;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public OBCashAccount5 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @NotNull
    @Size(min=1, max=256)
    @ApiModelProperty(required=true, value="Beneficiary account identification.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBCashAccount5 name(String name) {
        this.name = name;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="The account name is the name or names of the account owner(s) represented at an account level, as displayed by the ASPSP's online channels. Note, the account name is not the product name or the nickname of the account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBCashAccount5 secondaryIdentification(String secondaryIdentification) {
        this.secondaryIdentification = secondaryIdentification;
        return this;
    }

    @Size(min=1, max=34)
    @ApiModelProperty(value="This is secondary identification of the account, as assigned by the account servicing institution.  This can be used by building societies to additionally identify accounts with a roll number (in addition to a sort code and account number combination).")
    public String getSecondaryIdentification() {
        return this.secondaryIdentification;
    }

    public void setSecondaryIdentification(String secondaryIdentification) {
        this.secondaryIdentification = secondaryIdentification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCashAccount5 obCashAccount5 = (OBCashAccount5)o;
        return Objects.equals(this.schemeName, obCashAccount5.schemeName) && Objects.equals(this.identification, obCashAccount5.identification) && Objects.equals(this.name, obCashAccount5.name) && Objects.equals(this.secondaryIdentification, obCashAccount5.secondaryIdentification);
    }

    public int hashCode() {
        return Objects.hash(this.schemeName, this.identification, this.name, this.secondaryIdentification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBCashAccount5 {\n");
        sb.append("    schemeName: ").append(this.toIndentedString(this.schemeName)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    secondaryIdentification: ").append(this.toIndentedString(this.secondaryIdentification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

