/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBalanceType1Code;
import uk.org.openbanking.datamodel.account.OBCreditDebitCode;
import uk.org.openbanking.datamodel.account.OBCreditLine1;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Set of elements used to define the balance details.")
@Validated
public class OBCashBalance1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="CreditDebitIndicator")
    private OBCreditDebitCode creditDebitIndicator = null;
    @JsonProperty(value="Type")
    private OBBalanceType1Code type = null;
    @JsonProperty(value="DateTime")
    private DateTime dateTime = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;
    @JsonProperty(value="CreditLine")
    @Valid
    private List<OBCreditLine1> creditLine = null;

    public OBCashBalance1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBCashBalance1 creditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the balance is a credit or a debit balance.  Usage: A zero balance is considered to be a credit balance.")
    @NotNull
    public OBCreditDebitCode getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBCashBalance1 type(OBBalanceType1Code type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBBalanceType1Code getType() {
        return this.type;
    }

    public void setType(OBBalanceType1Code type) {
        this.type = type;
    }

    public OBCashBalance1 dateTime(DateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates the date (and time) of the balance. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public OBCashBalance1 amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public OBCashBalance1 creditLine(List<OBCreditLine1> creditLine) {
        this.creditLine = creditLine;
        return this;
    }

    public OBCashBalance1 addCreditLineItem(OBCreditLine1 creditLineItem) {
        if (this.creditLine == null) {
            this.creditLine = new ArrayList<OBCreditLine1>();
        }
        this.creditLine.add(creditLineItem);
        return this;
    }

    @ApiModelProperty(value="Set of elements used to provide details on the credit line.")
    @Valid
    public List<OBCreditLine1> getCreditLine() {
        return this.creditLine;
    }

    public void setCreditLine(List<OBCreditLine1> creditLine) {
        this.creditLine = creditLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCashBalance1 obCashBalance1 = (OBCashBalance1)o;
        return Objects.equals(this.accountId, obCashBalance1.accountId) && Objects.equals((Object)this.creditDebitIndicator, (Object)obCashBalance1.creditDebitIndicator) && Objects.equals((Object)this.type, (Object)obCashBalance1.type) && Objects.equals(this.dateTime, obCashBalance1.dateTime) && Objects.equals(this.amount, obCashBalance1.amount) && Objects.equals(this.creditLine, obCashBalance1.creditLine);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.creditDebitIndicator, this.type, this.dateTime, this.amount, this.creditLine});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBCashBalance1 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.dateTime)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditLine: ").append(this.toIndentedString(this.creditLine)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

