/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBTierBandSet1;

@ApiModel(description="Details about the interest that may be payable to the BCA account holders")
@Validated
public class OBCreditInterest1 {
    @JsonProperty(value="TierBandSet")
    @Valid
    private List<OBTierBandSet1> tierBandSet = new ArrayList<OBTierBandSet1>();

    public OBCreditInterest1 tierBandSet(List<OBTierBandSet1> tierBandSet) {
        this.tierBandSet = tierBandSet;
        return this;
    }

    public OBCreditInterest1 addTierBandSetItem(OBTierBandSet1 tierBandSetItem) {
        this.tierBandSet.add(tierBandSetItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The group of tiers or bands for which credit interest can be applied.")
    @NotNull
    @Valid
    @Size(min=1)
    public List<OBTierBandSet1> getTierBandSet() {
        return this.tierBandSet;
    }

    public void setTierBandSet(List<OBTierBandSet1> tierBandSet) {
        this.tierBandSet = tierBandSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCreditInterest1 creditInterest1 = (OBCreditInterest1)o;
        return Objects.equals(this.tierBandSet, creditInterest1.tierBandSet);
    }

    public int hashCode() {
        return Objects.hash(this.tierBandSet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBCreditInterest1 {\n");
        sb.append("    tierBandSet: ").append(this.toIndentedString(this.tierBandSet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

