/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Set of elements used to provide details on the currency exchange.")
@Validated
public class OBCurrencyExchange5 {
    @JsonProperty(value="SourceCurrency")
    private String sourceCurrency = null;
    @JsonProperty(value="TargetCurrency")
    private String targetCurrency = null;
    @JsonProperty(value="UnitCurrency")
    private String unitCurrency = null;
    @JsonProperty(value="ExchangeRate")
    private BigDecimal exchangeRate = null;
    @JsonProperty(value="ContractIdentification")
    private String contractIdentification = null;
    @JsonProperty(value="QuotationDate")
    private DateTime quotationDate = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;

    public OBCurrencyExchange5 sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="Currency from which an amount is to be converted in a currency conversion.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public OBCurrencyExchange5 targetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
        return this;
    }

    @ApiModelProperty(value="Currency from which an amount is to be converted in a currency conversion.")
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    public OBCurrencyExchange5 unitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
        return this;
    }

    @ApiModelProperty(value="Currency from which an amount is to be converted in a currency conversion.")
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getUnitCurrency() {
        return this.unitCurrency;
    }

    public void setUnitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
    }

    public OBCurrencyExchange5 exchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @ApiModelProperty(required=true, value="Factor used to convert an amount from one currency into another. This reflects the price at which one currency was bought with another currency. Usage: ExchangeRate expresses the ratio between UnitCurrency and QuotedCurrency (ExchangeRate = UnitCurrency/QuotedCurrency).")
    @NotNull
    @Valid
    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public OBCurrencyExchange5 contractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
        return this;
    }

    @ApiModelProperty(value="Unique identification to unambiguously identify the foreign exchange contract.")
    @Size(min=1, max=35)
    public String getContractIdentification() {
        return this.contractIdentification;
    }

    public void setContractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
    }

    public OBCurrencyExchange5 quotationDate(DateTime quotationDate) {
        this.quotationDate = quotationDate;
        return this;
    }

    @ApiModelProperty(value="Date and time at which an exchange rate is quoted. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getQuotationDate() {
        return this.quotationDate;
    }

    public void setQuotationDate(DateTime quotationDate) {
        this.quotationDate = quotationDate;
    }

    public OBCurrencyExchange5 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCurrencyExchange5 obCurrencyExchange5 = (OBCurrencyExchange5)o;
        return Objects.equals(this.sourceCurrency, obCurrencyExchange5.sourceCurrency) && Objects.equals(this.targetCurrency, obCurrencyExchange5.targetCurrency) && Objects.equals(this.unitCurrency, obCurrencyExchange5.unitCurrency) && Objects.equals(this.exchangeRate, obCurrencyExchange5.exchangeRate) && Objects.equals(this.contractIdentification, obCurrencyExchange5.contractIdentification) && Objects.equals(this.quotationDate, obCurrencyExchange5.quotationDate) && Objects.equals(this.instructedAmount, obCurrencyExchange5.instructedAmount);
    }

    public int hashCode() {
        return Objects.hash(this.sourceCurrency, this.targetCurrency, this.unitCurrency, this.exchangeRate, this.contractIdentification, this.quotationDate, this.instructedAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBCurrencyExchange5 {\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    targetCurrency: ").append(this.toIndentedString(this.targetCurrency)).append("\n");
        sb.append("    unitCurrency: ").append(this.toIndentedString(this.unitCurrency)).append("\n");
        sb.append("    exchangeRate: ").append(this.toIndentedString(this.exchangeRate)).append("\n");
        sb.append("    contractIdentification: ").append(this.toIndentedString(this.contractIdentification)).append("\n");
        sb.append("    quotationDate: ").append(this.toIndentedString(this.quotationDate)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

