/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@ApiModel(description="Amount of money to be moved between the debtor and creditor, before deduction of charges, expressed in the currency as ordered by the initiating party.")
public class OBCurrencyExchange5InstructedAmount {
    @JsonProperty(value="Amount")
    private String amount = null;
    @JsonProperty(value="Currency")
    private String currency = null;

    public OBCurrencyExchange5InstructedAmount amount(String amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\d{1,13}\\.\\d{1,5}$")
    @ApiModelProperty(required=true, value="")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public OBCurrencyExchange5InstructedAmount currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    @ApiModelProperty(required=true, value="")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCurrencyExchange5InstructedAmount obCurrencyExchange5InstructedAmount = (OBCurrencyExchange5InstructedAmount)o;
        return Objects.equals(this.amount, obCurrencyExchange5InstructedAmount.amount) && Objects.equals(this.currency, obCurrencyExchange5InstructedAmount.currency);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBCurrencyExchange5InstructedAmount {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

