/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBExternalDirectDebitStatus1Code;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Account to or from which a cash entry is made.")
@Validated
public class OBDirectDebit1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="DirectDebitId")
    private String directDebitId = null;
    @JsonProperty(value="MandateIdentification")
    private String mandateIdentification = null;
    @JsonProperty(value="DirectDebitStatusCode")
    private OBExternalDirectDebitStatus1Code directDebitStatusCode = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="PreviousPaymentDateTime")
    private DateTime previousPaymentDateTime = null;
    @JsonProperty(value="PreviousPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount previousPaymentAmount = null;

    public OBDirectDebit1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBDirectDebit1 directDebitId(String directDebitId) {
        this.directDebitId = directDebitId;
        return this;
    }

    @ApiModelProperty(value="A unique and immutable identifier used to identify the direct debit resource. This identifier has no meaning to the account owner.")
    @Size(min=1, max=40)
    public String getDirectDebitId() {
        return this.directDebitId;
    }

    public void setDirectDebitId(String directDebitId) {
        this.directDebitId = directDebitId;
    }

    public OBDirectDebit1 mandateIdentification(String mandateIdentification) {
        this.mandateIdentification = mandateIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Direct Debit reference. For AUDDIS service users provide Core Reference. For non AUDDIS service users provide Core reference if possible or last used reference.")
    @NotNull
    @Size(min=1, max=35)
    public String getMandateIdentification() {
        return this.mandateIdentification;
    }

    public void setMandateIdentification(String mandateIdentification) {
        this.mandateIdentification = mandateIdentification;
    }

    public OBDirectDebit1 directDebitStatusCode(OBExternalDirectDebitStatus1Code directDebitStatusCode) {
        this.directDebitStatusCode = directDebitStatusCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExternalDirectDebitStatus1Code getDirectDebitStatusCode() {
        return this.directDebitStatusCode;
    }

    public void setDirectDebitStatusCode(OBExternalDirectDebitStatus1Code directDebitStatusCode) {
        this.directDebitStatusCode = directDebitStatusCode;
    }

    public OBDirectDebit1 name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of Service User.")
    @NotNull
    @Size(min=1, max=70)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBDirectDebit1 previousPaymentDateTime(DateTime previousPaymentDateTime) {
        this.previousPaymentDateTime = previousPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="Date of most recent direct debit collection. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getPreviousPaymentDateTime() {
        return this.previousPaymentDateTime;
    }

    public void setPreviousPaymentDateTime(DateTime previousPaymentDateTime) {
        this.previousPaymentDateTime = previousPaymentDateTime;
    }

    public OBDirectDebit1 previousPaymentAmount(OBActiveOrHistoricCurrencyAndAmount previousPaymentAmount) {
        this.previousPaymentAmount = previousPaymentAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getPreviousPaymentAmount() {
        return this.previousPaymentAmount;
    }

    public void setPreviousPaymentAmount(OBActiveOrHistoricCurrencyAndAmount previousPaymentAmount) {
        this.previousPaymentAmount = previousPaymentAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBDirectDebit1 obDirectDebit1 = (OBDirectDebit1)o;
        return Objects.equals(this.accountId, obDirectDebit1.accountId) && Objects.equals(this.directDebitId, obDirectDebit1.directDebitId) && Objects.equals(this.mandateIdentification, obDirectDebit1.mandateIdentification) && Objects.equals((Object)this.directDebitStatusCode, (Object)obDirectDebit1.directDebitStatusCode) && Objects.equals(this.name, obDirectDebit1.name) && Objects.equals(this.previousPaymentDateTime, obDirectDebit1.previousPaymentDateTime) && Objects.equals(this.previousPaymentAmount, obDirectDebit1.previousPaymentAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.directDebitId, this.mandateIdentification, this.directDebitStatusCode, this.name, this.previousPaymentDateTime, this.previousPaymentAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBDirectDebit1 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    directDebitId: ").append(this.toIndentedString(this.directDebitId)).append("\n");
        sb.append("    mandateIdentification: ").append(this.toIndentedString(this.mandateIdentification)).append("\n");
        sb.append("    directDebitStatusCode: ").append(this.toIndentedString((Object)this.directDebitStatusCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    previousPaymentDateTime: ").append(this.toIndentedString(this.previousPaymentDateTime)).append("\n");
        sb.append("    previousPaymentAmount: ").append(this.toIndentedString(this.previousPaymentAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

