/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBFeeType1Code;
import uk.org.openbanking.datamodel.account.OBMinMaxType1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBPeriod1Code;

@ApiModel(description="Details about any caps (maximum charges) that apply to a particular or group of fee/charge")
@Validated
public class OBFeeChargeCap1 {
    @JsonProperty(value="FeeType")
    @Valid
    private List<OBFeeType1Code> feeType = new ArrayList<OBFeeType1Code>();
    @JsonProperty(value="MinMaxType")
    private OBMinMaxType1Code minMaxType = null;
    @JsonProperty(value="FeeCapOccurrence")
    private Float feeCapOccurrence = null;
    @JsonProperty(value="FeeCapAmount")
    private String feeCapAmount = null;
    @JsonProperty(value="CappingPeriod")
    private OBPeriod1Code cappingPeriod = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="OtherFeeType")
    @Valid
    private List<OBOtherCodeType1> otherFeeType = null;

    public OBFeeChargeCap1 feeType(List<OBFeeType1Code> feeType) {
        this.feeType = feeType;
        return this;
    }

    public OBFeeChargeCap1 addFeeTypeItem(OBFeeType1Code feeTypeItem) {
        this.feeType.add(feeTypeItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Fee/charge type which is being capped")
    @NotNull
    @Size(min=1)
    public List<OBFeeType1Code> getFeeType() {
        return this.feeType;
    }

    public void setFeeType(List<OBFeeType1Code> feeType) {
        this.feeType = feeType;
    }

    public OBFeeChargeCap1 minMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
        return this;
    }

    @ApiModelProperty(required=true, value="Min Max type")
    @NotNull
    public OBMinMaxType1Code getMinMaxType() {
        return this.minMaxType;
    }

    public void setMinMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
    }

    public OBFeeChargeCap1 feeCapOccurrence(Float feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
        return this;
    }

    @ApiModelProperty(value="fee/charges are captured dependent on the number of occurrences rather than capped at a particular amount")
    public Float getFeeCapOccurrence() {
        return this.feeCapOccurrence;
    }

    public void setFeeCapOccurrence(Float feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
    }

    public OBFeeChargeCap1 feeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
        return this;
    }

    @ApiModelProperty(value="Cap amount charged for a fee/charge (where it is charged in terms of an amount rather than a rate)")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getFeeCapAmount() {
        return this.feeCapAmount;
    }

    public void setFeeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
    }

    public OBFeeChargeCap1 cappingPeriod(OBPeriod1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
        return this;
    }

    @ApiModelProperty(value="Period e.g. day, week, month etc. for which the fee/charge is capped")
    public OBPeriod1Code getCappingPeriod() {
        return this.cappingPeriod;
    }

    public void setCappingPeriod(OBPeriod1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
    }

    public OBFeeChargeCap1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBFeeChargeCap1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Free text for adding  extra details for fee charge cap")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBFeeChargeCap1 otherFeeType(List<OBOtherCodeType1> otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    public OBFeeChargeCap1 addOtherFeeTypeItem(OBOtherCodeType1 otherFeeTypeItem) {
        if (this.otherFeeType == null) {
            this.otherFeeType = new ArrayList<OBOtherCodeType1>();
        }
        this.otherFeeType.add(otherFeeTypeItem);
        return this;
    }

    @ApiModelProperty(value="Other fee type code which is not available in the standard code set")
    @Valid
    public List<OBOtherCodeType1> getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(List<OBOtherCodeType1> otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBFeeChargeCap1 obBCAData1FeeChargeCap = (OBFeeChargeCap1)o;
        return Objects.equals(this.feeType, obBCAData1FeeChargeCap.feeType) && Objects.equals((Object)this.minMaxType, (Object)obBCAData1FeeChargeCap.minMaxType) && Objects.equals(this.feeCapOccurrence, obBCAData1FeeChargeCap.feeCapOccurrence) && Objects.equals(this.feeCapAmount, obBCAData1FeeChargeCap.feeCapAmount) && Objects.equals((Object)this.cappingPeriod, (Object)obBCAData1FeeChargeCap.cappingPeriod) && Objects.equals(this.notes, obBCAData1FeeChargeCap.notes) && Objects.equals(this.otherFeeType, obBCAData1FeeChargeCap.otherFeeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.minMaxType, this.feeCapOccurrence, this.feeCapAmount, this.cappingPeriod, this.notes, this.otherFeeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBFeeChargeCap1 {\n");
        sb.append("    feeType: ").append(this.toIndentedString(this.feeType)).append("\n");
        sb.append("    minMaxType: ").append(this.toIndentedString((Object)this.minMaxType)).append("\n");
        sb.append("    feeCapOccurrence: ").append(this.toIndentedString(this.feeCapOccurrence)).append("\n");
        sb.append("    feeCapAmount: ").append(this.toIndentedString(this.feeCapAmount)).append("\n");
        sb.append("    cappingPeriod: ").append(this.toIndentedString((Object)this.cappingPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

