/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBFeeApplicableRange1;
import uk.org.openbanking.datamodel.account.OBFeeCategory1Code;
import uk.org.openbanking.datamodel.account.OBFeeChargeCap1;
import uk.org.openbanking.datamodel.account.OBFeeFrequency1Code;
import uk.org.openbanking.datamodel.account.OBFeeType1Code;
import uk.org.openbanking.datamodel.account.OBInterestRateType1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBOtherFeeChargeDetailType;

@ApiModel(description="Other fees/charges details")
@Validated
public class OBFeeChargeDetail1 {
    @JsonProperty(value="FeeCategory")
    private OBFeeCategory1Code feeCategory = null;
    @JsonProperty(value="FeeType")
    private OBFeeType1Code feeType = null;
    @JsonProperty(value="NegotiableIndicator")
    private Boolean negotiableIndicator = null;
    @JsonProperty(value="FeeAmount")
    private String feeAmount = null;
    @JsonProperty(value="FeeRate")
    private String feeRate = null;
    @JsonProperty(value="FeeRateType")
    private OBInterestRateType1Code feeRateType = null;
    @JsonProperty(value="ApplicationFrequency")
    private OBFeeFrequency1Code applicationFrequency = null;
    @JsonProperty(value="CalculationFrequency")
    private OBFeeFrequency1Code calculationFrequency = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="FeeChargeCap")
    @Valid
    private List<OBFeeChargeCap1> feeChargeCap = null;
    @JsonProperty(value="OtherFeeCategoryType")
    private OBOtherCodeType1 otherFeeCategoryType = null;
    @JsonProperty(value="OtherFeeType")
    private OBOtherFeeChargeDetailType otherFeeType = null;
    @JsonProperty(value="OtherFeeRateType")
    private OBOtherCodeType1 otherFeeRateType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OBOtherCodeType1 otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OBOtherCodeType1 otherCalculationFrequency = null;
    @JsonProperty(value="OBFeeApplicableRange1")
    private OBFeeApplicableRange1 feeApplicableRange = null;

    public OBFeeChargeDetail1 feeCategory(OBFeeCategory1Code feeCategory) {
        this.feeCategory = feeCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="Categorisation of fees and charges into standard categories.")
    @NotNull
    public OBFeeCategory1Code getFeeCategory() {
        return this.feeCategory;
    }

    public void setFeeCategory(OBFeeCategory1Code feeCategory) {
        this.feeCategory = feeCategory;
    }

    public OBFeeChargeDetail1 feeType(OBFeeType1Code feeType) {
        this.feeType = feeType;
        return this;
    }

    @ApiModelProperty(required=true, value="Fee/Charge Type")
    @NotNull
    public OBFeeType1Code getFeeType() {
        return this.feeType;
    }

    public void setFeeType(OBFeeType1Code feeType) {
        this.feeType = feeType;
    }

    public OBFeeChargeDetail1 negotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
        return this;
    }

    @ApiModelProperty(value="Fee/charge which is usually negotiable rather than a fixed amount")
    public Boolean isNegotiableIndicator() {
        return this.negotiableIndicator;
    }

    public void setNegotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
    }

    public OBFeeChargeDetail1 feeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @ApiModelProperty(value="Fee Amount charged for a fee/charge (where it is charged in terms of an amount rather than a rate)")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
    }

    public OBFeeChargeDetail1 feeRate(String feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @ApiModelProperty(value="Rate charged for Fee/Charge (where it is charged in terms of a rate rather than an amount)")
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    public String getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(String feeRate) {
        this.feeRate = feeRate;
    }

    public OBFeeChargeDetail1 feeRateType(OBInterestRateType1Code feeRateType) {
        this.feeRateType = feeRateType;
        return this;
    }

    @ApiModelProperty(value="Rate type for Fee/Charge (where it is charged in terms of a rate rather than an amount)")
    public OBInterestRateType1Code getFeeRateType() {
        return this.feeRateType;
    }

    public void setFeeRateType(OBInterestRateType1Code feeRateType) {
        this.feeRateType = feeRateType;
    }

    public OBFeeChargeDetail1 applicationFrequency(OBFeeFrequency1Code applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @ApiModelProperty(required=true, value="How frequently the fee/charge is applied to the account")
    @NotNull
    public OBFeeFrequency1Code getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(OBFeeFrequency1Code applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public OBFeeChargeDetail1 calculationFrequency(OBFeeFrequency1Code calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How frequently the fee/charge is calculated")
    public OBFeeFrequency1Code getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(OBFeeFrequency1Code calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public OBFeeChargeDetail1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBFeeChargeDetail1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the fee/charge details.")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBFeeChargeDetail1 feeChargeCap(List<OBFeeChargeCap1> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
        return this;
    }

    public OBFeeChargeDetail1 addFeeChargeCapItem(OBFeeChargeCap1 feeChargeCapItem) {
        if (this.feeChargeCap == null) {
            this.feeChargeCap = new ArrayList<OBFeeChargeCap1>();
        }
        this.feeChargeCap.add(feeChargeCapItem);
        return this;
    }

    @ApiModelProperty(value="Details about any caps (maximum charges) that apply to a particular or group of fee/charge")
    @Valid
    public List<OBFeeChargeCap1> getFeeChargeCap() {
        return this.feeChargeCap;
    }

    public void setFeeChargeCap(List<OBFeeChargeCap1> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
    }

    public OBFeeChargeDetail1 otherFeeCategoryType(OBOtherCodeType1 otherFeeCategoryType) {
        this.otherFeeCategoryType = otherFeeCategoryType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherFeeCategoryType() {
        return this.otherFeeCategoryType;
    }

    public void setOtherFeeCategoryType(OBOtherCodeType1 otherFeeCategoryType) {
        this.otherFeeCategoryType = otherFeeCategoryType;
    }

    public OBFeeChargeDetail1 otherFeeType(OBOtherFeeChargeDetailType otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherFeeChargeDetailType getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(OBOtherFeeChargeDetailType otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public OBFeeChargeDetail1 otherFeeRateType(OBOtherCodeType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherFeeRateType() {
        return this.otherFeeRateType;
    }

    public void setOtherFeeRateType(OBOtherCodeType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
    }

    public OBFeeChargeDetail1 otherApplicationFrequency(OBOtherCodeType1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OBOtherCodeType1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public OBFeeChargeDetail1 otherCalculationFrequency(OBOtherCodeType1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OBOtherCodeType1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public OBFeeChargeDetail1 feeApplicableRange(OBFeeApplicableRange1 feeApplicableRange) {
        this.feeApplicableRange = feeApplicableRange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBFeeApplicableRange1 getFeeApplicableRange() {
        return this.feeApplicableRange;
    }

    public void setFeeApplicableRange(OBFeeApplicableRange1 feeApplicableRange) {
        this.feeApplicableRange = feeApplicableRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBFeeChargeDetail1 obBCAData1FeeChargeDetail = (OBFeeChargeDetail1)o;
        return Objects.equals((Object)this.feeCategory, (Object)obBCAData1FeeChargeDetail.feeCategory) && Objects.equals((Object)this.feeType, (Object)obBCAData1FeeChargeDetail.feeType) && Objects.equals(this.negotiableIndicator, obBCAData1FeeChargeDetail.negotiableIndicator) && Objects.equals(this.feeAmount, obBCAData1FeeChargeDetail.feeAmount) && Objects.equals(this.feeRate, obBCAData1FeeChargeDetail.feeRate) && Objects.equals((Object)this.feeRateType, (Object)obBCAData1FeeChargeDetail.feeRateType) && Objects.equals((Object)this.applicationFrequency, (Object)obBCAData1FeeChargeDetail.applicationFrequency) && Objects.equals((Object)this.calculationFrequency, (Object)obBCAData1FeeChargeDetail.calculationFrequency) && Objects.equals(this.notes, obBCAData1FeeChargeDetail.notes) && Objects.equals(this.feeChargeCap, obBCAData1FeeChargeDetail.feeChargeCap) && Objects.equals(this.otherFeeCategoryType, obBCAData1FeeChargeDetail.otherFeeCategoryType) && Objects.equals(this.otherFeeType, obBCAData1FeeChargeDetail.otherFeeType) && Objects.equals(this.otherFeeRateType, obBCAData1FeeChargeDetail.otherFeeRateType) && Objects.equals(this.otherApplicationFrequency, obBCAData1FeeChargeDetail.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, obBCAData1FeeChargeDetail.otherCalculationFrequency) && Objects.equals(this.feeApplicableRange, obBCAData1FeeChargeDetail.feeApplicableRange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeCategory, this.feeType, this.negotiableIndicator, this.feeAmount, this.feeRate, this.feeRateType, this.applicationFrequency, this.calculationFrequency, this.notes, this.feeChargeCap, this.otherFeeCategoryType, this.otherFeeType, this.otherFeeRateType, this.otherApplicationFrequency, this.otherCalculationFrequency, this.feeApplicableRange});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBFeeChargeDetail1 {\n");
        sb.append("    feeCategory: ").append(this.toIndentedString((Object)this.feeCategory)).append("\n");
        sb.append("    feeType: ").append(this.toIndentedString((Object)this.feeType)).append("\n");
        sb.append("    negotiableIndicator: ").append(this.toIndentedString(this.negotiableIndicator)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    feeRateType: ").append(this.toIndentedString((Object)this.feeRateType)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    feeChargeCap: ").append(this.toIndentedString(this.feeChargeCap)).append("\n");
        sb.append("    otherFeeCategoryType: ").append(this.toIndentedString(this.otherFeeCategoryType)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("    otherFeeRateType: ").append(this.toIndentedString(this.otherFeeRateType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("    feeApplicableRange: ").append(this.toIndentedString(this.feeApplicableRange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

