/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBInterestCalculationMethod1Code;
import uk.org.openbanking.datamodel.account.OBLoanInterestFeesCharges1;
import uk.org.openbanking.datamodel.account.OBLoanInterestTierBand1;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBTierBandType1Code;

@ApiModel(description="The group of tiers or bands for which debit interest can be applied.")
public class OBLoanInterestTierBandSet1 {
    @JsonProperty(value="TierBandMethod")
    private OBTierBandType1Code tierBandMethod = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="CalculationMethod")
    private OBInterestCalculationMethod1Code calculationMethod = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherCalculationMethod")
    private OBOtherCodeType1 otherCalculationMethod = null;
    @JsonProperty(value="LoanInterestTierBand")
    private List<OBLoanInterestTierBand1> loanInterestTierBand = new ArrayList<OBLoanInterestTierBand1>();
    @JsonProperty(value="LoanInterestFeesCharges")
    private List<OBLoanInterestFeesCharges1> loanInterestFeesCharges = null;

    public OBLoanInterestTierBandSet1 tierBandMethod(OBTierBandType1Code tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBTierBandType1Code getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(OBTierBandType1Code tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public OBLoanInterestTierBandSet1 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Loan interest tierbandset identification. Used by  loan providers for internal use purpose.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBLoanInterestTierBandSet1 calculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBInterestCalculationMethod1Code getCalculationMethod() {
        return this.calculationMethod;
    }

    public void setCalculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
    }

    public OBLoanInterestTierBandSet1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBLoanInterestTierBandSet1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier Band Set details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBLoanInterestTierBandSet1 otherCalculationMethod(OBOtherCodeType1 otherCalculationMethod) {
        this.otherCalculationMethod = otherCalculationMethod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType1 getOtherCalculationMethod() {
        return this.otherCalculationMethod;
    }

    public void setOtherCalculationMethod(OBOtherCodeType1 otherCalculationMethod) {
        this.otherCalculationMethod = otherCalculationMethod;
    }

    public OBLoanInterestTierBandSet1 loanInterestTierBand(List<OBLoanInterestTierBand1> loanInterestTierBand) {
        this.loanInterestTierBand = loanInterestTierBand;
        return this;
    }

    public OBLoanInterestTierBandSet1 addLoanInterestTierBandItem(OBLoanInterestTierBand1 loanInterestTierBandItem) {
        this.loanInterestTierBand.add(loanInterestTierBandItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="Tier Band Details")
    public List<OBLoanInterestTierBand1> getLoanInterestTierBand() {
        return this.loanInterestTierBand;
    }

    public void setLoanInterestTierBand(List<OBLoanInterestTierBand1> loanInterestTierBand) {
        this.loanInterestTierBand = loanInterestTierBand;
    }

    public OBLoanInterestTierBandSet1 loanInterestFeesCharges(List<OBLoanInterestFeesCharges1> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
        return this;
    }

    public OBLoanInterestTierBandSet1 addLoanInterestFeesChargesItem(OBLoanInterestFeesCharges1 loanInterestFeesChargesItem) {
        if (this.loanInterestFeesCharges == null) {
            this.loanInterestFeesCharges = new ArrayList<OBLoanInterestFeesCharges1>();
        }
        this.loanInterestFeesCharges.add(loanInterestFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Contains details of fees and charges which are not associated with either LoanRepayment or features/benefits")
    public List<OBLoanInterestFeesCharges1> getLoanInterestFeesCharges() {
        return this.loanInterestFeesCharges;
    }

    public void setLoanInterestFeesCharges(List<OBLoanInterestFeesCharges1> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBLoanInterestTierBandSet1 obLoanInterestTierBandSet1 = (OBLoanInterestTierBandSet1)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)obLoanInterestTierBandSet1.tierBandMethod) && Objects.equals(this.identification, obLoanInterestTierBandSet1.identification) && Objects.equals((Object)this.calculationMethod, (Object)obLoanInterestTierBandSet1.calculationMethod) && Objects.equals(this.notes, obLoanInterestTierBandSet1.notes) && Objects.equals(this.otherCalculationMethod, obLoanInterestTierBandSet1.otherCalculationMethod) && Objects.equals(this.loanInterestTierBand, obLoanInterestTierBandSet1.loanInterestTierBand) && Objects.equals(this.loanInterestFeesCharges, obLoanInterestTierBandSet1.loanInterestFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.identification, this.calculationMethod, this.notes, this.otherCalculationMethod, this.loanInterestTierBand, this.loanInterestFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBLoanInterestTierBandSet1 {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    calculationMethod: ").append(this.toIndentedString((Object)this.calculationMethod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherCalculationMethod: ").append(this.toIndentedString(this.otherCalculationMethod)).append("\n");
        sb.append("    loanInterestTierBand: ").append(this.toIndentedString(this.loanInterestTierBand)).append("\n");
        sb.append("    loanInterestFeesCharges: ").append(this.toIndentedString(this.loanInterestFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

