/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBOverdraftFeesCharges1;
import uk.org.openbanking.datamodel.account.OBPeriod1Code;
import uk.org.openbanking.datamodel.account.OBTierBandType1Code;

@ApiModel(description="Provides overdraft details for a specific tier or band")
@Validated
public class OBOverdraftTierBand1 {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMin")
    private String tierValueMin = null;
    @JsonProperty(value="TierValueMax")
    private String tierValueMax = null;
    @JsonProperty(value="EAR")
    private String EAR = null;
    @JsonProperty(value="AgreementLengthMin")
    private Float agreementLengthMin = null;
    @JsonProperty(value="AgreementLengthMax")
    private Float agreementLengthMax = null;
    @JsonProperty(value="AgreementPeriod")
    private OBPeriod1Code agreementPeriod = null;
    @JsonProperty(value="OverdraftInterestChargingCoverage")
    private OBTierBandType1Code overdraftInterestChargingCoverage = null;
    @JsonProperty(value="BankGuaranteedIndicator")
    private Boolean bankGuaranteedIndicator = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="OverdraftFeesCharges")
    @Valid
    private List<OBOverdraftFeesCharges1> overdraftFeesCharges = null;

    public OBOverdraftTierBand1 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a overdraft.")
    @Size(min=1, max=35)
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBOverdraftTierBand1 tierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
        return this;
    }

    @ApiModelProperty(required=true, value="Minimum value of Overdraft Tier/Band")
    @NotNull
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getTierValueMin() {
        return this.tierValueMin;
    }

    public void setTierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
    }

    public OBOverdraftTierBand1 tierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
        return this;
    }

    @ApiModelProperty(value="Maximum value of Overdraft Tier/Band")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getTierValueMax() {
        return this.tierValueMax;
    }

    public void setTierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
    }

    public OBOverdraftTierBand1 EAR(String EAR) {
        this.EAR = EAR;
        return this;
    }

    @ApiModelProperty(value="EAR means Effective Annual Rate and/or Equivalent Annual Rate (frequently used interchangeably), being the actual annual interest rate of an Overdraft.")
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    public String getEAR() {
        return this.EAR;
    }

    public void setEAR(String EAR) {
        this.EAR = EAR;
    }

    public OBOverdraftTierBand1 agreementLengthMin(Float agreementLengthMin) {
        this.agreementLengthMin = agreementLengthMin;
        return this;
    }

    @ApiModelProperty(value="Specifies the minimum length of a band for a fixed overdraft agreement")
    public Float getAgreementLengthMin() {
        return this.agreementLengthMin;
    }

    public void setAgreementLengthMin(Float agreementLengthMin) {
        this.agreementLengthMin = agreementLengthMin;
    }

    public OBOverdraftTierBand1 agreementLengthMax(Float agreementLengthMax) {
        this.agreementLengthMax = agreementLengthMax;
        return this;
    }

    @ApiModelProperty(value="Specifies the maximum length of a band for a fixed overdraft agreement")
    public Float getAgreementLengthMax() {
        return this.agreementLengthMax;
    }

    public void setAgreementLengthMax(Float agreementLengthMax) {
        this.agreementLengthMax = agreementLengthMax;
    }

    public OBOverdraftTierBand1 agreementPeriod(OBPeriod1Code agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
        return this;
    }

    @ApiModelProperty(value="Specifies the period of a fixed length overdraft agreement")
    public OBPeriod1Code getAgreementPeriod() {
        return this.agreementPeriod;
    }

    public void setAgreementPeriod(OBPeriod1Code agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
    }

    public OBOverdraftTierBand1 overdraftInterestChargingCoverage(OBTierBandType1Code overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
        return this;
    }

    @ApiModelProperty(value="Refers to which interest rate is applied when interests are tiered. For example, if an overdraft balance is \u00a32k and the interest tiers are:- 0-\u00a3500 0.1%, 500-1000 0.2%, 1000-10000 0.5%, then the applicable interest rate could either be 0.5% of the entire balance (since the account balance sits in the top interest tier) or (0.1%*500)+(0.2%*500)+(0.5%*1000). In the 1st situation, we say the interest is applied to the \u2018Whole\u2019 of the account balance,  and in the 2nd that it is \u2018Tiered\u2019.")
    public OBTierBandType1Code getOverdraftInterestChargingCoverage() {
        return this.overdraftInterestChargingCoverage;
    }

    public void setOverdraftInterestChargingCoverage(OBTierBandType1Code overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
    }

    public OBOverdraftTierBand1 bankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the advertised overdraft rate is guaranteed to be offered to a borrower by the bank e.g. if it\u2019s part of a government scheme, or whether the rate may vary dependent on the applicant\u2019s circumstances.")
    public Boolean isBankGuaranteedIndicator() {
        return this.bankGuaranteedIndicator;
    }

    public void setBankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
    }

    public OBOverdraftTierBand1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBOverdraftTierBand1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier/band details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBOverdraftTierBand1 overdraftFeesCharges(List<OBOverdraftFeesCharges1> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
        return this;
    }

    public OBOverdraftTierBand1 addOverdraftFeesChargesItem(OBOverdraftFeesCharges1 overdraftFeesChargesItem) {
        if (this.overdraftFeesCharges == null) {
            this.overdraftFeesCharges = new ArrayList<OBOverdraftFeesCharges1>();
        }
        this.overdraftFeesCharges.add(overdraftFeesChargesItem);
        return this;
    }

    @ApiModelProperty(value="Overdraft fees and charges")
    @Valid
    public List<OBOverdraftFeesCharges1> getOverdraftFeesCharges() {
        return this.overdraftFeesCharges;
    }

    public void setOverdraftFeesCharges(List<OBOverdraftFeesCharges1> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBOverdraftTierBand1 overdraft1OverdraftTierBand = (OBOverdraftTierBand1)o;
        return Objects.equals(this.identification, overdraft1OverdraftTierBand.identification) && Objects.equals(this.tierValueMin, overdraft1OverdraftTierBand.tierValueMin) && Objects.equals(this.tierValueMax, overdraft1OverdraftTierBand.tierValueMax) && Objects.equals(this.EAR, overdraft1OverdraftTierBand.EAR) && Objects.equals(this.agreementLengthMin, overdraft1OverdraftTierBand.agreementLengthMin) && Objects.equals(this.agreementLengthMax, overdraft1OverdraftTierBand.agreementLengthMax) && Objects.equals((Object)this.agreementPeriod, (Object)overdraft1OverdraftTierBand.agreementPeriod) && Objects.equals((Object)this.overdraftInterestChargingCoverage, (Object)overdraft1OverdraftTierBand.overdraftInterestChargingCoverage) && Objects.equals(this.bankGuaranteedIndicator, overdraft1OverdraftTierBand.bankGuaranteedIndicator) && Objects.equals(this.notes, overdraft1OverdraftTierBand.notes) && Objects.equals(this.overdraftFeesCharges, overdraft1OverdraftTierBand.overdraftFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMin, this.tierValueMax, this.EAR, this.agreementLengthMin, this.agreementLengthMax, this.agreementPeriod, this.overdraftInterestChargingCoverage, this.bankGuaranteedIndicator, this.notes, this.overdraftFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBOverdraftTierBand1 {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMin: ").append(this.toIndentedString(this.tierValueMin)).append("\n");
        sb.append("    tierValueMax: ").append(this.toIndentedString(this.tierValueMax)).append("\n");
        sb.append("    EAR: ").append(this.toIndentedString(this.EAR)).append("\n");
        sb.append("    agreementLengthMin: ").append(this.toIndentedString(this.agreementLengthMin)).append("\n");
        sb.append("    agreementLengthMax: ").append(this.toIndentedString(this.agreementLengthMax)).append("\n");
        sb.append("    agreementPeriod: ").append(this.toIndentedString((Object)this.agreementPeriod)).append("\n");
        sb.append("    overdraftInterestChargingCoverage: ").append(this.toIndentedString((Object)this.overdraftInterestChargingCoverage)).append("\n");
        sb.append("    bankGuaranteedIndicator: ").append(this.toIndentedString(this.bankGuaranteedIndicator)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftFeesCharges: ").append(this.toIndentedString(this.overdraftFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

