/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBExternalPartyType1Code;
import uk.org.openbanking.datamodel.account.OBPostalAddress8;

@Validated
public class OBParty1 {
    @JsonProperty(value="PartyId")
    private String partyId = null;
    @JsonProperty(value="PartyNumber")
    private String partyNumber = null;
    @JsonProperty(value="PartyType")
    private OBExternalPartyType1Code partyType = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="EmailAddress")
    private String emailAddress = null;
    @JsonProperty(value="Phone")
    private String phone = null;
    @JsonProperty(value="Mobile")
    private String mobile = null;
    @JsonProperty(value="Address")
    @Valid
    private List<OBPostalAddress8> address = null;

    public OBParty1 partyId(String partyId) {
        this.partyId = partyId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique and immutable identifier used to identify the customer resource. This identifier has no meaning to the account owner.")
    @NotNull
    @Size(min=1, max=40)
    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public OBParty1 partyNumber(String partyNumber) {
        this.partyNumber = partyNumber;
        return this;
    }

    @ApiModelProperty(value="Number assigned by an agent to identify its customer.")
    @Size(min=1, max=35)
    public String getPartyNumber() {
        return this.partyNumber;
    }

    public void setPartyNumber(String partyNumber) {
        this.partyNumber = partyNumber;
    }

    public OBParty1 partyType(OBExternalPartyType1Code partyType) {
        this.partyType = partyType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExternalPartyType1Code getPartyType() {
        return this.partyType;
    }

    public void setPartyType(OBExternalPartyType1Code partyType) {
        this.partyType = partyType;
    }

    public OBParty1 name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name by which a party is known and which is usually used to identify that party.")
    @Size(min=1, max=70)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBParty1 emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="Address for electronic mail (e-mail).")
    @Size(min=1, max=256)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public OBParty1 phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="Collection of information that identifies a phone number, as defined by telecom services.")
    @Pattern(regexp="\\+[0-9]{1,3}-[0-9()+\\-]{1,30}")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public OBParty1 mobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    @ApiModelProperty(value="Collection of information that identifies a mobile phone number, as defined by telecom services.")
    @Pattern(regexp="\\+[0-9]{1,3}-[0-9()+\\-]{1,30}")
    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public OBParty1 address(List<OBPostalAddress8> address) {
        this.address = address;
        return this;
    }

    public OBParty1 addAddressItem(OBPostalAddress8 addressItem) {
        if (this.address == null) {
            this.address = new ArrayList<OBPostalAddress8>();
        }
        this.address.add(addressItem);
        return this;
    }

    @ApiModelProperty(value="Postal address of a party.")
    @Valid
    public List<OBPostalAddress8> getAddress() {
        return this.address;
    }

    public void setAddress(List<OBPostalAddress8> address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBParty1 obParty1 = (OBParty1)o;
        return Objects.equals(this.partyId, obParty1.partyId) && Objects.equals(this.partyNumber, obParty1.partyNumber) && Objects.equals((Object)this.partyType, (Object)obParty1.partyType) && Objects.equals(this.name, obParty1.name) && Objects.equals(this.emailAddress, obParty1.emailAddress) && Objects.equals(this.phone, obParty1.phone) && Objects.equals(this.mobile, obParty1.mobile) && Objects.equals(this.address, obParty1.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partyId, this.partyNumber, this.partyType, this.name, this.emailAddress, this.phone, this.mobile, this.address});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBParty1 {\n");
        sb.append("    partyId: ").append(this.toIndentedString(this.partyId)).append("\n");
        sb.append("    partyNumber: ").append(this.toIndentedString(this.partyNumber)).append("\n");
        sb.append("    partyType: ").append(this.toIndentedString((Object)this.partyType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    mobile: ").append(this.toIndentedString(this.mobile)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

