/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBExternalPartyType1Code;
import uk.org.openbanking.datamodel.account.OBPartyRelationships1;
import uk.org.openbanking.datamodel.account.OBPostalAddress8;

public class OBParty2 {
    @JsonProperty(value="PartyId")
    private String partyId = null;
    @JsonProperty(value="PartyNumber")
    private String partyNumber = null;
    @JsonProperty(value="PartyType")
    private OBExternalPartyType1Code partyType = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="FullLegalName")
    private String fullLegalName = null;
    @JsonProperty(value="LegalStructure")
    private String legalStructure = null;
    @JsonProperty(value="BeneficialOwnership")
    private Boolean beneficialOwnership = null;
    @JsonProperty(value="AccountRole")
    private String accountRole = null;
    @JsonProperty(value="EmailAddress")
    private String emailAddress = null;
    @JsonProperty(value="Phone")
    private String phone = null;
    @JsonProperty(value="Mobile")
    private String mobile = null;
    @JsonProperty(value="Relationships")
    private OBPartyRelationships1 relationships = null;
    @JsonProperty(value="Address")
    private List<OBPostalAddress8> address = null;

    public OBParty2 partyId(String partyId) {
        this.partyId = partyId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="A unique and immutable identifier used to identify the customer resource. This identifier has no meaning to the account owner.")
    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public OBParty2 partyNumber(String partyNumber) {
        this.partyNumber = partyNumber;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Number assigned by an agent to identify its customer.")
    public String getPartyNumber() {
        return this.partyNumber;
    }

    public void setPartyNumber(String partyNumber) {
        this.partyNumber = partyNumber;
    }

    public OBParty2 partyType(OBExternalPartyType1Code partyType) {
        this.partyType = partyType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBExternalPartyType1Code getPartyType() {
        return this.partyType;
    }

    public void setPartyType(OBExternalPartyType1Code partyType) {
        this.partyType = partyType;
    }

    public OBParty2 name(String name) {
        this.name = name;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="Name by which a party is known and which is usually used to identify that party.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBParty2 fullLegalName(String fullLegalName) {
        this.fullLegalName = fullLegalName;
        return this;
    }

    @Size(min=1, max=350)
    @ApiModelProperty(value="The full legal name of the party.")
    public String getFullLegalName() {
        return this.fullLegalName;
    }

    public void setFullLegalName(String fullLegalName) {
        this.fullLegalName = fullLegalName;
    }

    public OBParty2 legalStructure(String legalStructure) {
        this.legalStructure = legalStructure;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="")
    public String getLegalStructure() {
        return this.legalStructure;
    }

    public void setLegalStructure(String legalStructure) {
        this.legalStructure = legalStructure;
    }

    public OBParty2 beneficialOwnership(Boolean beneficialOwnership) {
        this.beneficialOwnership = beneficialOwnership;
        return this;
    }

    @ApiModelProperty(value="A flag to indicate a party\u2019s beneficial ownership of the related account.")
    public Boolean isBeneficialOwnership() {
        return this.beneficialOwnership;
    }

    public void setBeneficialOwnership(Boolean beneficialOwnership) {
        this.beneficialOwnership = beneficialOwnership;
    }

    public OBParty2 accountRole(String accountRole) {
        this.accountRole = accountRole;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="")
    public String getAccountRole() {
        return this.accountRole;
    }

    public void setAccountRole(String accountRole) {
        this.accountRole = accountRole;
    }

    public OBParty2 emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Size(min=1, max=256)
    @ApiModelProperty(value="Address for electronic mail (e-mail).")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public OBParty2 phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Pattern(regexp="\\+[0-9]{1,3}-[0-9()+\\-]{1,30}")
    @ApiModelProperty(value="Collection of information that identifies a phone number, as defined by telecom services.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public OBParty2 mobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    @Pattern(regexp="\\+[0-9]{1,3}-[0-9()+\\-]{1,30}")
    @ApiModelProperty(value="Collection of information that identifies a mobile phone number, as defined by telecom services.")
    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public OBParty2 relationships(OBPartyRelationships1 relationships) {
        this.relationships = relationships;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBPartyRelationships1 getRelationships() {
        return this.relationships;
    }

    public void setRelationships(OBPartyRelationships1 relationships) {
        this.relationships = relationships;
    }

    public OBParty2 address(List<OBPostalAddress8> address) {
        this.address = address;
        return this;
    }

    public OBParty2 addAddressItem(OBPostalAddress8 addressItem) {
        if (this.address == null) {
            this.address = new ArrayList<OBPostalAddress8>();
        }
        this.address.add(addressItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Postal address of a party.")
    public List<OBPostalAddress8> getAddress() {
        return this.address;
    }

    public void setAddress(List<OBPostalAddress8> address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBParty2 obParty2 = (OBParty2)o;
        return Objects.equals(this.partyId, obParty2.partyId) && Objects.equals(this.partyNumber, obParty2.partyNumber) && Objects.equals((Object)this.partyType, (Object)obParty2.partyType) && Objects.equals(this.name, obParty2.name) && Objects.equals(this.fullLegalName, obParty2.fullLegalName) && Objects.equals(this.legalStructure, obParty2.legalStructure) && Objects.equals(this.beneficialOwnership, obParty2.beneficialOwnership) && Objects.equals(this.accountRole, obParty2.accountRole) && Objects.equals(this.emailAddress, obParty2.emailAddress) && Objects.equals(this.phone, obParty2.phone) && Objects.equals(this.mobile, obParty2.mobile) && Objects.equals(this.relationships, obParty2.relationships) && Objects.equals(this.address, obParty2.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partyId, this.partyNumber, this.partyType, this.name, this.fullLegalName, this.legalStructure, this.beneficialOwnership, this.accountRole, this.emailAddress, this.phone, this.mobile, this.relationships, this.address});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBParty2 {\n");
        sb.append("    partyId: ").append(this.toIndentedString(this.partyId)).append("\n");
        sb.append("    partyNumber: ").append(this.toIndentedString(this.partyNumber)).append("\n");
        sb.append("    partyType: ").append(this.toIndentedString((Object)this.partyType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fullLegalName: ").append(this.toIndentedString(this.fullLegalName)).append("\n");
        sb.append("    legalStructure: ").append(this.toIndentedString(this.legalStructure)).append("\n");
        sb.append("    beneficialOwnership: ").append(this.toIndentedString(this.beneficialOwnership)).append("\n");
        sb.append("    accountRole: ").append(this.toIndentedString(this.accountRole)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    mobile: ").append(this.toIndentedString(this.mobile)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

