/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBAddressTypeCode;

@ApiModel(description="Postal address of a party.")
public class OBParty2Address {
    @JsonProperty(value="AddressType")
    private OBAddressTypeCode addressType = null;
    @JsonProperty(value="AddressLine")
    private List<String> addressLine = null;
    @JsonProperty(value="StreetName")
    private String streetName = null;
    @JsonProperty(value="BuildingNumber")
    private String buildingNumber = null;
    @JsonProperty(value="PostCode")
    private String postCode = null;
    @JsonProperty(value="TownName")
    private String townName = null;
    @JsonProperty(value="CountrySubDivision")
    private String countrySubDivision = null;
    @JsonProperty(value="Country")
    private String country = null;

    public OBParty2Address addressType(OBAddressTypeCode addressType) {
        this.addressType = addressType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBAddressTypeCode getAddressType() {
        return this.addressType;
    }

    public void setAddressType(OBAddressTypeCode addressType) {
        this.addressType = addressType;
    }

    public OBParty2Address addressLine(List<String> addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    public OBParty2Address addAddressLineItem(String addressLineItem) {
        if (this.addressLine == null) {
            this.addressLine = new ArrayList<String>();
        }
        this.addressLine.add(addressLineItem);
        return this;
    }

    @Size(min=0, max=5)
    @ApiModelProperty(value="")
    public List<String> getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(List<String> addressLine) {
        this.addressLine = addressLine;
    }

    public OBParty2Address streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="")
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public OBParty2Address buildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
        return this;
    }

    @Size(min=1, max=16)
    @ApiModelProperty(value="")
    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public OBParty2Address postCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @Size(min=1, max=16)
    @ApiModelProperty(value="")
    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public OBParty2Address townName(String townName) {
        this.townName = townName;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="")
    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public OBParty2Address countrySubDivision(String countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="")
    public String getCountrySubDivision() {
        return this.countrySubDivision;
    }

    public void setCountrySubDivision(String countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
    }

    public OBParty2Address country(String country) {
        this.country = country;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{2,2}$")
    @ApiModelProperty(required=true, value="")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBParty2Address obParty2Address = (OBParty2Address)o;
        return Objects.equals((Object)this.addressType, (Object)obParty2Address.addressType) && Objects.equals(this.addressLine, obParty2Address.addressLine) && Objects.equals(this.streetName, obParty2Address.streetName) && Objects.equals(this.buildingNumber, obParty2Address.buildingNumber) && Objects.equals(this.postCode, obParty2Address.postCode) && Objects.equals(this.townName, obParty2Address.townName) && Objects.equals(this.countrySubDivision, obParty2Address.countrySubDivision) && Objects.equals(this.country, obParty2Address.country);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressType, this.addressLine, this.streetName, this.buildingNumber, this.postCode, this.townName, this.countrySubDivision, this.country});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBParty2Address {\n");
        sb.append("    addressType: ").append(this.toIndentedString((Object)this.addressType)).append("\n");
        sb.append("    addressLine: ").append(this.toIndentedString(this.addressLine)).append("\n");
        sb.append("    streetName: ").append(this.toIndentedString(this.streetName)).append("\n");
        sb.append("    buildingNumber: ").append(this.toIndentedString(this.buildingNumber)).append("\n");
        sb.append("    postCode: ").append(this.toIndentedString(this.postCode)).append("\n");
        sb.append("    townName: ").append(this.toIndentedString(this.townName)).append("\n");
        sb.append("    countrySubDivision: ").append(this.toIndentedString(this.countrySubDivision)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

