/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBAddressTypeCode;

@ApiModel(description="Postal address of a party.")
@Validated
public class OBPostalAddress8 {
    @JsonProperty(value="AddressType")
    private OBAddressTypeCode addressType = null;
    @JsonProperty(value="AddressLine")
    @Valid
    private List<String> addressLine = null;
    @JsonProperty(value="StreetName")
    private String streetName = null;
    @JsonProperty(value="BuildingNumber")
    private String buildingNumber = null;
    @JsonProperty(value="PostCode")
    private String postCode = null;
    @JsonProperty(value="TownName")
    private String townName = null;
    @JsonProperty(value="CountrySubDivision")
    private String countrySubDivision = null;
    @JsonProperty(value="Country")
    private String country = null;

    public OBPostalAddress8 addressType(OBAddressTypeCode addressType) {
        this.addressType = addressType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBAddressTypeCode getAddressType() {
        return this.addressType;
    }

    public void setAddressType(OBAddressTypeCode addressType) {
        this.addressType = addressType;
    }

    public OBPostalAddress8 addressLine(List<String> addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    public OBPostalAddress8 addAddressLineItem(String addressLineItem) {
        if (this.addressLine == null) {
            this.addressLine = new ArrayList<String>();
        }
        this.addressLine.add(addressLineItem);
        return this;
    }

    @ApiModelProperty(value="Information that locates and identifies a specific address, as defined by postal services, that is presented in free format text.")
    @Size(min=0, max=5)
    public List<String> getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(List<String> addressLine) {
        this.addressLine = addressLine;
    }

    public OBPostalAddress8 streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    @ApiModelProperty(value="Name of a street or thoroughfare.")
    @Size(min=1, max=70)
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public OBPostalAddress8 buildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
        return this;
    }

    @ApiModelProperty(value="Number that identifies the position of a building on a street.")
    @Size(min=1, max=16)
    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public OBPostalAddress8 postCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @ApiModelProperty(value="Identifier consisting of a group of letters and/or numbers that is added to a postal address to assist the sorting of mail.")
    @Size(min=1, max=16)
    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public OBPostalAddress8 townName(String townName) {
        this.townName = townName;
        return this;
    }

    @ApiModelProperty(value="Name of a built-up area, with defined boundaries, and a local government.")
    @Size(min=1, max=35)
    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public OBPostalAddress8 countrySubDivision(String countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
        return this;
    }

    @ApiModelProperty(value="Identifies a subdivision of a country eg, state, region, county.")
    @Size(min=1, max=35)
    public String getCountrySubDivision() {
        return this.countrySubDivision;
    }

    public void setCountrySubDivision(String countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
    }

    public OBPostalAddress8 country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="Nation with its own government, occupying a particular territory.")
    @NotNull
    @Pattern(regexp="^[A-Z]{2,2}$")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBPostalAddress8 obPostalAddress8 = (OBPostalAddress8)o;
        return Objects.equals((Object)this.addressType, (Object)obPostalAddress8.addressType) && Objects.equals(this.addressLine, obPostalAddress8.addressLine) && Objects.equals(this.streetName, obPostalAddress8.streetName) && Objects.equals(this.buildingNumber, obPostalAddress8.buildingNumber) && Objects.equals(this.postCode, obPostalAddress8.postCode) && Objects.equals(this.townName, obPostalAddress8.townName) && Objects.equals(this.countrySubDivision, obPostalAddress8.countrySubDivision) && Objects.equals(this.country, obPostalAddress8.country);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressType, this.addressLine, this.streetName, this.buildingNumber, this.postCode, this.townName, this.countrySubDivision, this.country});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBPostalAddress8 {\n");
        sb.append("    addressType: ").append(this.toIndentedString((Object)this.addressType)).append("\n");
        sb.append("    addressLine: ").append(this.toIndentedString(this.addressLine)).append("\n");
        sb.append("    streetName: ").append(this.toIndentedString(this.streetName)).append("\n");
        sb.append("    buildingNumber: ").append(this.toIndentedString(this.buildingNumber)).append("\n");
        sb.append("    postCode: ").append(this.toIndentedString(this.postCode)).append("\n");
        sb.append("    townName: ").append(this.toIndentedString(this.townName)).append("\n");
        sb.append("    countrySubDivision: ").append(this.toIndentedString(this.countrySubDivision)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

