/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBBalanceType1Code;
import uk.org.openbanking.datamodel.account.OBCreditDebitCode2;
import uk.org.openbanking.datamodel.account.OBReadBalance1DataAmount;
import uk.org.openbanking.datamodel.account.OBReadBalance1DataCreditLine;

@ApiModel(description="Set of elements used to define the balance details.")
public class OBReadBalance1DataBalance {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="CreditDebitIndicator")
    private OBCreditDebitCode2 creditDebitIndicator = null;
    @JsonProperty(value="Type")
    private OBBalanceType1Code type = null;
    @JsonProperty(value="DateTime")
    private String dateTime = null;
    @JsonProperty(value="Amount")
    private OBReadBalance1DataAmount amount = null;
    @JsonProperty(value="CreditLine")
    private List<OBReadBalance1DataCreditLine> creditLine = null;

    public OBReadBalance1DataBalance accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBReadBalance1DataBalance creditDebitIndicator(OBCreditDebitCode2 creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBCreditDebitCode2 getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(OBCreditDebitCode2 creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBReadBalance1DataBalance type(OBBalanceType1Code type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBBalanceType1Code getType() {
        return this.type;
    }

    public void setType(OBBalanceType1Code type) {
        this.type = type;
    }

    public OBReadBalance1DataBalance dateTime(String dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Indicates the date (and time) of the balance.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public OBReadBalance1DataBalance amount(OBReadBalance1DataAmount amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBReadBalance1DataAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBReadBalance1DataAmount amount) {
        this.amount = amount;
    }

    public OBReadBalance1DataBalance creditLine(List<OBReadBalance1DataCreditLine> creditLine) {
        this.creditLine = creditLine;
        return this;
    }

    public OBReadBalance1DataBalance addCreditLineItem(OBReadBalance1DataCreditLine creditLineItem) {
        if (this.creditLine == null) {
            this.creditLine = new ArrayList<OBReadBalance1DataCreditLine>();
        }
        this.creditLine.add(creditLineItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBReadBalance1DataCreditLine> getCreditLine() {
        return this.creditLine;
    }

    public void setCreditLine(List<OBReadBalance1DataCreditLine> creditLine) {
        this.creditLine = creditLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadBalance1DataBalance obReadBalance1DataBalance = (OBReadBalance1DataBalance)o;
        return Objects.equals(this.accountId, obReadBalance1DataBalance.accountId) && Objects.equals((Object)this.creditDebitIndicator, (Object)obReadBalance1DataBalance.creditDebitIndicator) && Objects.equals((Object)this.type, (Object)obReadBalance1DataBalance.type) && Objects.equals(this.dateTime, obReadBalance1DataBalance.dateTime) && Objects.equals(this.amount, obReadBalance1DataBalance.amount) && Objects.equals(this.creditLine, obReadBalance1DataBalance.creditLine);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.creditDebitIndicator, this.type, this.dateTime, this.amount, this.creditLine});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadBalance1DataBalance {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.dateTime)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditLine: ").append(this.toIndentedString(this.creditLine)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

