/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class OBReadConsent1Data {
    @JsonProperty(value="Permissions")
    private List<PermissionsEnum> permissions = new ArrayList<PermissionsEnum>();
    @JsonProperty(value="ExpirationDateTime")
    private String expirationDateTime = null;
    @JsonProperty(value="TransactionFromDateTime")
    private String transactionFromDateTime = null;
    @JsonProperty(value="TransactionToDateTime")
    private String transactionToDateTime = null;

    public OBReadConsent1Data permissions(List<PermissionsEnum> permissions) {
        this.permissions = permissions;
        return this;
    }

    public OBReadConsent1Data addPermissionsItem(PermissionsEnum permissionsItem) {
        this.permissions.add(permissionsItem);
        return this;
    }

    @NotNull
    @Size(min=1)
    @ApiModelProperty(required=true, value="")
    public List<PermissionsEnum> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<PermissionsEnum> permissions) {
        this.permissions = permissions;
    }

    public OBReadConsent1Data expirationDateTime(String expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified date and time the permissions will expire. If this is not populated, the permissions will be open ended.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public String getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(String expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public OBReadConsent1Data transactionFromDateTime(String transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified start date and time for the transaction query period. If this is not populated, the start date will be open ended, and data will be returned from the earliest available transaction.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public String getTransactionFromDateTime() {
        return this.transactionFromDateTime;
    }

    public void setTransactionFromDateTime(String transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
    }

    public OBReadConsent1Data transactionToDateTime(String transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified end date and time for the transaction query period. If this is not populated, the end date will be open ended, and data will be returned to the latest available transaction.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public String getTransactionToDateTime() {
        return this.transactionToDateTime;
    }

    public void setTransactionToDateTime(String transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadConsent1Data obReadConsent1Data = (OBReadConsent1Data)o;
        return Objects.equals(this.permissions, obReadConsent1Data.permissions) && Objects.equals(this.expirationDateTime, obReadConsent1Data.expirationDateTime) && Objects.equals(this.transactionFromDateTime, obReadConsent1Data.transactionFromDateTime) && Objects.equals(this.transactionToDateTime, obReadConsent1Data.transactionToDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.permissions, this.expirationDateTime, this.transactionFromDateTime, this.transactionToDateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadConsent1Data {\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("    transactionFromDateTime: ").append(this.toIndentedString(this.transactionFromDateTime)).append("\n");
        sb.append("    transactionToDateTime: ").append(this.toIndentedString(this.transactionToDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PermissionsEnum {
        READACCOUNTSBASIC("ReadAccountsBasic"),
        READACCOUNTSDETAIL("ReadAccountsDetail"),
        READBALANCES("ReadBalances"),
        READBENEFICIARIESBASIC("ReadBeneficiariesBasic"),
        READBENEFICIARIESDETAIL("ReadBeneficiariesDetail"),
        READDIRECTDEBITS("ReadDirectDebits"),
        READOFFERS("ReadOffers"),
        READPAN("ReadPAN"),
        READPARTY("ReadParty"),
        READPARTYPSU("ReadPartyPSU"),
        READPRODUCTS("ReadProducts"),
        READSCHEDULEDPAYMENTSBASIC("ReadScheduledPaymentsBasic"),
        READSCHEDULEDPAYMENTSDETAIL("ReadScheduledPaymentsDetail"),
        READSTANDINGORDERSBASIC("ReadStandingOrdersBasic"),
        READSTANDINGORDERSDETAIL("ReadStandingOrdersDetail"),
        READSTATEMENTSBASIC("ReadStatementsBasic"),
        READSTATEMENTSDETAIL("ReadStatementsDetail"),
        READTRANSACTIONSBASIC("ReadTransactionsBasic"),
        READTRANSACTIONSCREDITS("ReadTransactionsCredits"),
        READTRANSACTIONSDEBITS("ReadTransactionsDebits"),
        READTRANSACTIONSDETAIL("ReadTransactionsDetail");

        private String value;

        private PermissionsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PermissionsEnum fromValue(String text) {
            for (PermissionsEnum b : PermissionsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

