/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.account.OBExternalPermissions1Code;
import uk.org.openbanking.datamodel.account.OBExternalRequestStatus1Code;
import uk.org.openbanking.jackson.DateTimeDeserializer;
import uk.org.openbanking.jackson.DateTimeSerializer;

@ApiModel(description="Account Request Response")
public class OBReadDataResponse1 {
    @JsonProperty(value="AccountRequestId")
    private String accountRequestId = null;
    @JsonProperty(value="Status")
    private OBExternalRequestStatus1Code status = null;
    @JsonProperty(value="CreationDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime creationDateTime = null;
    @JsonProperty(value="Permissions")
    private List<OBExternalPermissions1Code> permissions = new ArrayList<OBExternalPermissions1Code>();
    @JsonProperty(value="ExpirationDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime expirationDateTime = null;
    @JsonProperty(value="TransactionFromDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime transactionFromDateTime = null;
    @JsonProperty(value="TransactionToDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime transactionToDateTime = null;

    public OBReadDataResponse1 accountRequestId(String accountRequestId) {
        this.accountRequestId = accountRequestId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification as assigned to identify the account request resource.")
    @NotNull
    @Size(min=1, max=128)
    public String getAccountRequestId() {
        return this.accountRequestId;
    }

    public void setAccountRequestId(String accountRequestId) {
        this.accountRequestId = accountRequestId;
    }

    public OBReadDataResponse1 status(OBExternalRequestStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Specifies the status of the account request resource.")
    public OBExternalRequestStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBExternalRequestStatus1Code status) {
        this.status = status;
    }

    public OBReadDataResponse1 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource was created.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBReadDataResponse1 permissions(List<OBExternalPermissions1Code> permissions) {
        this.permissions = permissions;
        return this;
    }

    public OBReadDataResponse1 addPermissionsItem(OBExternalPermissions1Code permissionsItem) {
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the Open Banking account request types. This is a list of the data clusters being consented by the PSU, and requested for authorisation with the ASPSP.")
    @NotNull
    public List<OBExternalPermissions1Code> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<OBExternalPermissions1Code> permissions) {
        this.permissions = permissions;
    }

    public OBReadDataResponse1 expirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified date and time the permissions will expire. If this is not populated, the permissions will be open ended.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public OBReadDataResponse1 transactionFromDateTime(DateTime transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified start date and time for the transaction query period. If this is not populated, the start date will be open ended, and data will be returned from the earliest available transaction.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getTransactionFromDateTime() {
        return this.transactionFromDateTime;
    }

    public void setTransactionFromDateTime(DateTime transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
    }

    public OBReadDataResponse1 transactionToDateTime(DateTime transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified end date and time for the transaction query period. If this is not populated, the end date will be open ended, and data will be returned to the latest available transaction.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getTransactionToDateTime() {
        return this.transactionToDateTime;
    }

    public void setTransactionToDateTime(DateTime transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadDataResponse1 data1 = (OBReadDataResponse1)o;
        return Objects.equals(this.accountRequestId, data1.accountRequestId) && Objects.equals((Object)this.status, (Object)data1.status) && Objects.equals(this.creationDateTime, data1.creationDateTime) && Objects.equals(this.permissions, data1.permissions) && Objects.equals(this.expirationDateTime, data1.expirationDateTime) && Objects.equals(this.transactionFromDateTime, data1.transactionFromDateTime) && Objects.equals(this.transactionToDateTime, data1.transactionToDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountRequestId, this.status, this.creationDateTime, this.permissions, this.expirationDateTime, this.transactionFromDateTime, this.transactionToDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Data1 {\n");
        sb.append("    accountRequestId: ").append(this.toIndentedString(this.accountRequestId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("    transactionFromDateTime: ").append(this.toIndentedString(this.transactionFromDateTime)).append("\n");
        sb.append("    transactionToDateTime: ").append(this.toIndentedString(this.transactionToDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

