/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBReadOffer1DataAmount;
import uk.org.openbanking.datamodel.account.OBReadOffer1DataFee;

public class OBReadOffer1DataOffer {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="OfferId")
    private String offerId = null;
    @JsonProperty(value="OfferType")
    private OfferTypeEnum offerType = null;
    @JsonProperty(value="Description")
    private String description = null;
    @JsonProperty(value="StartDateTime")
    private String startDateTime = null;
    @JsonProperty(value="EndDateTime")
    private String endDateTime = null;
    @JsonProperty(value="Rate")
    private String rate = null;
    @JsonProperty(value="Value")
    private Integer value = null;
    @JsonProperty(value="Term")
    private String term = null;
    @JsonProperty(value="URL")
    private String URL = null;
    @JsonProperty(value="Amount")
    private OBReadOffer1DataAmount amount = null;
    @JsonProperty(value="Fee")
    private OBReadOffer1DataFee fee = null;

    public OBReadOffer1DataOffer accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBReadOffer1DataOffer offerId(String offerId) {
        this.offerId = offerId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="A unique and immutable identifier used to identify the offer resource. This identifier has no meaning to the account owner.")
    public String getOfferId() {
        return this.offerId;
    }

    public void setOfferId(String offerId) {
        this.offerId = offerId;
    }

    public OBReadOffer1DataOffer offerType(OfferTypeEnum offerType) {
        this.offerType = offerType;
        return this;
    }

    @ApiModelProperty(value="Offer type, in a coded form.")
    public OfferTypeEnum getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OfferTypeEnum offerType) {
        this.offerType = offerType;
    }

    public OBReadOffer1DataOffer description(String description) {
        this.description = description;
        return this;
    }

    @Size(min=1, max=500)
    @ApiModelProperty(value="Further details of the offer.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OBReadOffer1DataOffer startDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which the offer starts.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public String getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
    }

    public OBReadOffer1DataOffer endDateTime(String endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which the offer ends.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public String getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(String endDateTime) {
        this.endDateTime = endDateTime;
    }

    public OBReadOffer1DataOffer rate(String rate) {
        this.rate = rate;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Rate associated with the offer type.")
    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public OBReadOffer1DataOffer value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Value associated with the offer type.")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public OBReadOffer1DataOffer term(String term) {
        this.term = term;
        return this;
    }

    @Size(min=1, max=500)
    @ApiModelProperty(value="Further details of the term of the offer.")
    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public OBReadOffer1DataOffer URL(String URL2) {
        this.URL = URL2;
        return this;
    }

    @Size(min=1, max=256)
    @ApiModelProperty(value="URL (Uniform Resource Locator) where documentation on the offer can be found")
    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public OBReadOffer1DataOffer amount(OBReadOffer1DataAmount amount) {
        this.amount = amount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBReadOffer1DataAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBReadOffer1DataAmount amount) {
        this.amount = amount;
    }

    public OBReadOffer1DataOffer fee(OBReadOffer1DataFee fee) {
        this.fee = fee;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBReadOffer1DataFee getFee() {
        return this.fee;
    }

    public void setFee(OBReadOffer1DataFee fee) {
        this.fee = fee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadOffer1DataOffer obReadOffer1DataOffer = (OBReadOffer1DataOffer)o;
        return Objects.equals(this.accountId, obReadOffer1DataOffer.accountId) && Objects.equals(this.offerId, obReadOffer1DataOffer.offerId) && Objects.equals((Object)this.offerType, (Object)obReadOffer1DataOffer.offerType) && Objects.equals(this.description, obReadOffer1DataOffer.description) && Objects.equals(this.startDateTime, obReadOffer1DataOffer.startDateTime) && Objects.equals(this.endDateTime, obReadOffer1DataOffer.endDateTime) && Objects.equals(this.rate, obReadOffer1DataOffer.rate) && Objects.equals(this.value, obReadOffer1DataOffer.value) && Objects.equals(this.term, obReadOffer1DataOffer.term) && Objects.equals(this.URL, obReadOffer1DataOffer.URL) && Objects.equals(this.amount, obReadOffer1DataOffer.amount) && Objects.equals(this.fee, obReadOffer1DataOffer.fee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.offerId, this.offerType, this.description, this.startDateTime, this.endDateTime, this.rate, this.value, this.term, this.URL, this.amount, this.fee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadOffer1DataOffer {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    offerId: ").append(this.toIndentedString(this.offerId)).append("\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    term: ").append(this.toIndentedString(this.term)).append("\n");
        sb.append("    URL: ").append(this.toIndentedString(this.URL)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OfferTypeEnum {
        BALANCETRANSFER("BalanceTransfer"),
        LIMITINCREASE("LimitIncrease"),
        MONEYTRANSFER("MoneyTransfer"),
        OTHER("Other"),
        PROMOTIONALRATE("PromotionalRate");

        private String value;

        private OfferTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OfferTypeEnum fromValue(String text) {
            for (OfferTypeEnum b : OfferTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

