/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBInterestFixedVariableType1Code;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeLoanInterestOtherLoanProviderInterestRateType;

@ApiModel(description="Tier Band Details")
public class OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMinimum")
    private String tierValueMinimum = null;
    @JsonProperty(value="TierValueMaximum")
    private String tierValueMaximum = null;
    @JsonProperty(value="TierValueMinTerm")
    private Integer tierValueMinTerm = null;
    @JsonProperty(value="MinTermPeriod")
    private MinTermPeriodEnum minTermPeriod = null;
    @JsonProperty(value="TierValueMaxTerm")
    private Integer tierValueMaxTerm = null;
    @JsonProperty(value="MaxTermPeriod")
    private MaxTermPeriodEnum maxTermPeriod = null;
    @JsonProperty(value="FixedVariableInterestRateType")
    private OBInterestFixedVariableType1Code fixedVariableInterestRateType = null;
    @JsonProperty(value="RepAPR")
    private String repAPR = null;
    @JsonProperty(value="LoanProviderInterestRateType")
    private LoanProviderInterestRateTypeEnum loanProviderInterestRateType = null;
    @JsonProperty(value="LoanProviderInterestRate")
    private String loanProviderInterestRate = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherLoanProviderInterestRateType")
    private OBReadProduct2DataOtherProductTypeLoanInterestOtherLoanProviderInterestRateType otherLoanProviderInterestRateType = null;
    @JsonProperty(value="LoanInterestFeesCharges")
    private List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> loanInterestFeesCharges = null;

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a SME Loan.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand tierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\\\d{1,14}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="Minimum loan value for which the loan interest tier applies.")
    public String getTierValueMinimum() {
        return this.tierValueMinimum;
    }

    public void setTierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand tierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
        return this;
    }

    @Pattern(regexp="^(-?\\\\d{1,14}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Maximum loan value for which the loan interest tier applies.")
    public String getTierValueMaximum() {
        return this.tierValueMaximum;
    }

    public void setTierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand tierValueMinTerm(Integer tierValueMinTerm) {
        this.tierValueMinTerm = tierValueMinTerm;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Minimum loan term for which the loan interest tier applies.")
    public Integer getTierValueMinTerm() {
        return this.tierValueMinTerm;
    }

    public void setTierValueMinTerm(Integer tierValueMinTerm) {
        this.tierValueMinTerm = tierValueMinTerm;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand minTermPeriod(MinTermPeriodEnum minTermPeriod) {
        this.minTermPeriod = minTermPeriod;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The unit of period (days, weeks, months etc.) of the Minimum Term")
    public MinTermPeriodEnum getMinTermPeriod() {
        return this.minTermPeriod;
    }

    public void setMinTermPeriod(MinTermPeriodEnum minTermPeriod) {
        this.minTermPeriod = minTermPeriod;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand tierValueMaxTerm(Integer tierValueMaxTerm) {
        this.tierValueMaxTerm = tierValueMaxTerm;
        return this;
    }

    @ApiModelProperty(value="Maximum loan term for which the loan interest tier applies.")
    public Integer getTierValueMaxTerm() {
        return this.tierValueMaxTerm;
    }

    public void setTierValueMaxTerm(Integer tierValueMaxTerm) {
        this.tierValueMaxTerm = tierValueMaxTerm;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand maxTermPeriod(MaxTermPeriodEnum maxTermPeriod) {
        this.maxTermPeriod = maxTermPeriod;
        return this;
    }

    @ApiModelProperty(value="The unit of period (days, weeks, months etc.) of the Maximum Term")
    public MaxTermPeriodEnum getMaxTermPeriod() {
        return this.maxTermPeriod;
    }

    public void setMaxTermPeriod(MaxTermPeriodEnum maxTermPeriod) {
        this.maxTermPeriod = maxTermPeriod;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand fixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBInterestFixedVariableType1Code getFixedVariableInterestRateType() {
        return this.fixedVariableInterestRateType;
    }

    public void setFixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand repAPR(String repAPR) {
        this.repAPR = repAPR;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\\\d{1,3}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="The annual equivalent rate (AER) is interest that is calculated under the assumption that any interest paid is combined with the original balance and the next interest payment will be based on the slightly higher account balance. Overall, this means that interest can be compounded several times in a year depending on the number of times that interest payments are made.  For SME Loan, this APR is the representative APR which includes any account fees.")
    public String getRepAPR() {
        return this.repAPR;
    }

    public void setRepAPR(String repAPR) {
        this.repAPR = repAPR;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand loanProviderInterestRateType(LoanProviderInterestRateTypeEnum loanProviderInterestRateType) {
        this.loanProviderInterestRateType = loanProviderInterestRateType;
        return this;
    }

    @ApiModelProperty(value="Interest rate types, other than APR, which financial institutions may use to describe the annual interest rate payable for the SME Loan.")
    public LoanProviderInterestRateTypeEnum getLoanProviderInterestRateType() {
        return this.loanProviderInterestRateType;
    }

    public void setLoanProviderInterestRateType(LoanProviderInterestRateTypeEnum loanProviderInterestRateType) {
        this.loanProviderInterestRateType = loanProviderInterestRateType;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand loanProviderInterestRate(String loanProviderInterestRate) {
        this.loanProviderInterestRate = loanProviderInterestRate;
        return this;
    }

    @Pattern(regexp="^(-?\\\\d{1,3}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Loan provider Interest for the SME Loan product")
    public String getLoanProviderInterestRate() {
        return this.loanProviderInterestRate;
    }

    public void setLoanProviderInterestRate(String loanProviderInterestRate) {
        this.loanProviderInterestRate = loanProviderInterestRate;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand otherLoanProviderInterestRateType(OBReadProduct2DataOtherProductTypeLoanInterestOtherLoanProviderInterestRateType otherLoanProviderInterestRateType) {
        this.otherLoanProviderInterestRateType = otherLoanProviderInterestRateType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBReadProduct2DataOtherProductTypeLoanInterestOtherLoanProviderInterestRateType getOtherLoanProviderInterestRateType() {
        return this.otherLoanProviderInterestRateType;
    }

    public void setOtherLoanProviderInterestRateType(OBReadProduct2DataOtherProductTypeLoanInterestOtherLoanProviderInterestRateType otherLoanProviderInterestRateType) {
        this.otherLoanProviderInterestRateType = otherLoanProviderInterestRateType;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand loanInterestFeesCharges(List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand addLoanInterestFeesChargesItem(OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges loanInterestFeesChargesItem) {
        if (this.loanInterestFeesCharges == null) {
            this.loanInterestFeesCharges = new ArrayList<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges>();
        }
        this.loanInterestFeesCharges.add(loanInterestFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> getLoanInterestFeesCharges() {
        return this.loanInterestFeesCharges;
    }

    public void setLoanInterestFeesCharges(List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand = (OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand)o;
        return Objects.equals(this.identification, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.identification) && Objects.equals(this.tierValueMinimum, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.tierValueMinimum) && Objects.equals(this.tierValueMaximum, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.tierValueMaximum) && Objects.equals(this.tierValueMinTerm, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.tierValueMinTerm) && Objects.equals((Object)this.minTermPeriod, (Object)obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.minTermPeriod) && Objects.equals(this.tierValueMaxTerm, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.tierValueMaxTerm) && Objects.equals((Object)this.maxTermPeriod, (Object)obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.maxTermPeriod) && Objects.equals((Object)this.fixedVariableInterestRateType, (Object)obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.fixedVariableInterestRateType) && Objects.equals(this.repAPR, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.repAPR) && Objects.equals((Object)this.loanProviderInterestRateType, (Object)obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.loanProviderInterestRateType) && Objects.equals(this.loanProviderInterestRate, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.loanProviderInterestRate) && Objects.equals(this.notes, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.notes) && Objects.equals(this.otherLoanProviderInterestRateType, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.otherLoanProviderInterestRateType) && Objects.equals(this.loanInterestFeesCharges, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand.loanInterestFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMinimum, this.tierValueMaximum, this.tierValueMinTerm, this.minTermPeriod, this.tierValueMaxTerm, this.maxTermPeriod, this.fixedVariableInterestRateType, this.repAPR, this.loanProviderInterestRateType, this.loanProviderInterestRate, this.notes, this.otherLoanProviderInterestRateType, this.loanInterestFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMinimum: ").append(this.toIndentedString(this.tierValueMinimum)).append("\n");
        sb.append("    tierValueMaximum: ").append(this.toIndentedString(this.tierValueMaximum)).append("\n");
        sb.append("    tierValueMinTerm: ").append(this.toIndentedString(this.tierValueMinTerm)).append("\n");
        sb.append("    minTermPeriod: ").append(this.toIndentedString((Object)this.minTermPeriod)).append("\n");
        sb.append("    tierValueMaxTerm: ").append(this.toIndentedString(this.tierValueMaxTerm)).append("\n");
        sb.append("    maxTermPeriod: ").append(this.toIndentedString((Object)this.maxTermPeriod)).append("\n");
        sb.append("    fixedVariableInterestRateType: ").append(this.toIndentedString((Object)this.fixedVariableInterestRateType)).append("\n");
        sb.append("    repAPR: ").append(this.toIndentedString(this.repAPR)).append("\n");
        sb.append("    loanProviderInterestRateType: ").append(this.toIndentedString((Object)this.loanProviderInterestRateType)).append("\n");
        sb.append("    loanProviderInterestRate: ").append(this.toIndentedString(this.loanProviderInterestRate)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherLoanProviderInterestRateType: ").append(this.toIndentedString(this.otherLoanProviderInterestRateType)).append("\n");
        sb.append("    loanInterestFeesCharges: ").append(this.toIndentedString(this.loanInterestFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LoanProviderInterestRateTypeEnum {
        INBB("INBB"),
        INFR("INFR"),
        INGR("INGR"),
        INLR("INLR"),
        INNE("INNE"),
        INOT("INOT");

        private String value;

        private LoanProviderInterestRateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LoanProviderInterestRateTypeEnum fromValue(String text) {
            for (LoanProviderInterestRateTypeEnum b : LoanProviderInterestRateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MaxTermPeriodEnum {
        PACT("PACT"),
        PDAY("PDAY"),
        PHYR("PHYR"),
        PMTH("PMTH"),
        PQTR("PQTR"),
        PWEK("PWEK"),
        PYER("PYER");

        private String value;

        private MaxTermPeriodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MaxTermPeriodEnum fromValue(String text) {
            for (MaxTermPeriodEnum b : MaxTermPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MinTermPeriodEnum {
        PACT("PACT"),
        PDAY("PDAY"),
        PHYR("PHYR"),
        PMTH("PMTH"),
        PQTR("PQTR"),
        PWEK("PWEK"),
        PYER("PYER");

        private String value;

        private MinTermPeriodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MinTermPeriodEnum fromValue(String text) {
            for (MinTermPeriodEnum b : MinTermPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

