/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBInterestCalculationMethod1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType10;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand;

@ApiModel(description="The group of tiers or bands for which debit interest can be applied.")
public class OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet {
    @JsonProperty(value="TierBandMethod")
    private TierBandMethodEnum tierBandMethod = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="CalculationMethod")
    private OBInterestCalculationMethod1Code calculationMethod = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherCalculationMethod")
    private OBOtherCodeType10 otherCalculationMethod = null;
    @JsonProperty(value="LoanInterestTierBand")
    private List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand> loanInterestTierBand = new ArrayList<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand>();
    @JsonProperty(value="LoanInterestFeesCharges")
    private List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> loanInterestFeesCharges = null;

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet tierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The methodology of how credit interest is charged. It can be:- 1. Banded Interest rates are banded. i.e. Increasing rate on whole balance as balance increases. 2. Tiered Interest rates are tiered. i.e. increasing rate for each tier as balance increases, but interest paid on tier fixed for that tier and not on whole balance. 3. Whole The same interest rate is applied irrespective of the SME Loan balance")
    public TierBandMethodEnum getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Loan interest tierbandset identification. Used by  loan providers for internal use purpose.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet calculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBInterestCalculationMethod1Code getCalculationMethod() {
        return this.calculationMethod;
    }

    public void setCalculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet otherCalculationMethod(OBOtherCodeType10 otherCalculationMethod) {
        this.otherCalculationMethod = otherCalculationMethod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType10 getOtherCalculationMethod() {
        return this.otherCalculationMethod;
    }

    public void setOtherCalculationMethod(OBOtherCodeType10 otherCalculationMethod) {
        this.otherCalculationMethod = otherCalculationMethod;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet loanInterestTierBand(List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand> loanInterestTierBand) {
        this.loanInterestTierBand = loanInterestTierBand;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet addLoanInterestTierBandItem(OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand loanInterestTierBandItem) {
        this.loanInterestTierBand.add(loanInterestTierBandItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="")
    public List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand> getLoanInterestTierBand() {
        return this.loanInterestTierBand;
    }

    public void setLoanInterestTierBand(List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBand> loanInterestTierBand) {
        this.loanInterestTierBand = loanInterestTierBand;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet loanInterestFeesCharges(List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet addLoanInterestFeesChargesItem(OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges loanInterestFeesChargesItem) {
        if (this.loanInterestFeesCharges == null) {
            this.loanInterestFeesCharges = new ArrayList<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges>();
        }
        this.loanInterestFeesCharges.add(loanInterestFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> getLoanInterestFeesCharges() {
        return this.loanInterestFeesCharges;
    }

    public void setLoanInterestFeesCharges(List<OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestFeesCharges> loanInterestFeesCharges) {
        this.loanInterestFeesCharges = loanInterestFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet = (OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet.tierBandMethod) && Objects.equals(this.identification, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet.identification) && Objects.equals((Object)this.calculationMethod, (Object)obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet.calculationMethod) && Objects.equals(this.notes, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet.notes) && Objects.equals(this.otherCalculationMethod, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet.otherCalculationMethod) && Objects.equals(this.loanInterestTierBand, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet.loanInterestTierBand) && Objects.equals(this.loanInterestFeesCharges, obReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet.loanInterestFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.identification, this.calculationMethod, this.notes, this.otherCalculationMethod, this.loanInterestTierBand, this.loanInterestFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataOtherProductTypeLoanInterestLoanInterestTierBandSet {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    calculationMethod: ").append(this.toIndentedString((Object)this.calculationMethod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherCalculationMethod: ").append(this.toIndentedString(this.otherCalculationMethod)).append("\n");
        sb.append("    loanInterestTierBand: ").append(this.toIndentedString(this.loanInterestTierBand)).append("\n");
        sb.append("    loanInterestFeesCharges: ").append(this.toIndentedString(this.loanInterestFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TierBandMethodEnum {
        INBA("INBA"),
        INTI("INTI"),
        INWH("INWH");

        private String value;

        private TierBandMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TierBandMethodEnum fromValue(String text) {
            for (TierBandMethodEnum b : TierBandMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

