/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeesCharges;

@ApiModel(description="Provides overdraft details for a specific tier or band")
public class OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMin")
    private String tierValueMin = null;
    @JsonProperty(value="TierValueMax")
    private String tierValueMax = null;
    @JsonProperty(value="EAR")
    private String EAR = null;
    @JsonProperty(value="AgreementLengthMin")
    private Integer agreementLengthMin = null;
    @JsonProperty(value="AgreementLengthMax")
    private Integer agreementLengthMax = null;
    @JsonProperty(value="AgreementPeriod")
    private AgreementPeriodEnum agreementPeriod = null;
    @JsonProperty(value="OverdraftInterestChargingCoverage")
    private OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage = null;
    @JsonProperty(value="BankGuaranteedIndicator")
    private Boolean bankGuaranteedIndicator = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OverdraftFeesCharges")
    private List<OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeesCharges> overdraftFeesCharges = null;

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a overdraft.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand tierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\\\d{1,14}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="Minimum value of Overdraft Tier/Band")
    public String getTierValueMin() {
        return this.tierValueMin;
    }

    public void setTierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand tierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
        return this;
    }

    @Pattern(regexp="^(-?\\\\d{1,14}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Maximum value of Overdraft Tier/Band")
    public String getTierValueMax() {
        return this.tierValueMax;
    }

    public void setTierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand EAR(String EAR) {
        this.EAR = EAR;
        return this;
    }

    @Pattern(regexp="^(-?\\\\d{1,3}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(value="EAR means Effective Annual Rate and/or Equivalent Annual Rate (frequently used interchangeably), being the actual annual interest rate of an Overdraft.")
    public String getEAR() {
        return this.EAR;
    }

    public void setEAR(String EAR) {
        this.EAR = EAR;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand agreementLengthMin(Integer agreementLengthMin) {
        this.agreementLengthMin = agreementLengthMin;
        return this;
    }

    @ApiModelProperty(value="Specifies the minimum length of a band for a fixed overdraft agreement")
    public Integer getAgreementLengthMin() {
        return this.agreementLengthMin;
    }

    public void setAgreementLengthMin(Integer agreementLengthMin) {
        this.agreementLengthMin = agreementLengthMin;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand agreementLengthMax(Integer agreementLengthMax) {
        this.agreementLengthMax = agreementLengthMax;
        return this;
    }

    @ApiModelProperty(value="Specifies the maximum length of a band for a fixed overdraft agreement")
    public Integer getAgreementLengthMax() {
        return this.agreementLengthMax;
    }

    public void setAgreementLengthMax(Integer agreementLengthMax) {
        this.agreementLengthMax = agreementLengthMax;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand agreementPeriod(AgreementPeriodEnum agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
        return this;
    }

    @ApiModelProperty(value="Specifies the period of a fixed length overdraft agreement")
    public AgreementPeriodEnum getAgreementPeriod() {
        return this.agreementPeriod;
    }

    public void setAgreementPeriod(AgreementPeriodEnum agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand overdraftInterestChargingCoverage(OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
        return this;
    }

    @ApiModelProperty(value="Refers to which interest rate is applied when interests are tiered. For example, if an overdraft balance is \ufffd2k and the interest tiers are:- 0-\ufffd500 0.1%, 500-1000 0.2%, 1000-10000 0.5%, then the applicable interest rate could either be 0.5% of the entire balance (since the account balance sits in the top interest tier) or (0.1%*500)+(0.2%*500)+(0.5%*1000). In the 1st situation, we say the interest is applied to the \ufffdWhole\ufffd of the account balance,  and in the 2nd that it is \ufffdTiered\ufffd.")
    public OverdraftInterestChargingCoverageEnum getOverdraftInterestChargingCoverage() {
        return this.overdraftInterestChargingCoverage;
    }

    public void setOverdraftInterestChargingCoverage(OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand bankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the advertised overdraft rate is guaranteed to be offered to a borrower by the bank e.g. if it\ufffds part of a government scheme, or whether the rate may vary dependent on the applicant\ufffds circumstances.")
    public Boolean isBankGuaranteedIndicator() {
        return this.bankGuaranteedIndicator;
    }

    public void setBankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand overdraftFeesCharges(List<OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeesCharges> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand addOverdraftFeesChargesItem(OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeesCharges overdraftFeesChargesItem) {
        if (this.overdraftFeesCharges == null) {
            this.overdraftFeesCharges = new ArrayList<OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeesCharges>();
        }
        this.overdraftFeesCharges.add(overdraftFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeesCharges> getOverdraftFeesCharges() {
        return this.overdraftFeesCharges;
    }

    public void setOverdraftFeesCharges(List<OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeesCharges> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand = (OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand)o;
        return Objects.equals(this.identification, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.identification) && Objects.equals(this.tierValueMin, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.tierValueMin) && Objects.equals(this.tierValueMax, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.tierValueMax) && Objects.equals(this.EAR, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.EAR) && Objects.equals(this.agreementLengthMin, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.agreementLengthMin) && Objects.equals(this.agreementLengthMax, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.agreementLengthMax) && Objects.equals((Object)this.agreementPeriod, (Object)obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.agreementPeriod) && Objects.equals((Object)this.overdraftInterestChargingCoverage, (Object)obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.overdraftInterestChargingCoverage) && Objects.equals(this.bankGuaranteedIndicator, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.bankGuaranteedIndicator) && Objects.equals(this.notes, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.notes) && Objects.equals(this.overdraftFeesCharges, obReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand.overdraftFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMin, this.tierValueMax, this.EAR, this.agreementLengthMin, this.agreementLengthMax, this.agreementPeriod, this.overdraftInterestChargingCoverage, this.bankGuaranteedIndicator, this.notes, this.overdraftFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataOtherProductTypeOverdraftOverdraftTierBand {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMin: ").append(this.toIndentedString(this.tierValueMin)).append("\n");
        sb.append("    tierValueMax: ").append(this.toIndentedString(this.tierValueMax)).append("\n");
        sb.append("    EAR: ").append(this.toIndentedString(this.EAR)).append("\n");
        sb.append("    agreementLengthMin: ").append(this.toIndentedString(this.agreementLengthMin)).append("\n");
        sb.append("    agreementLengthMax: ").append(this.toIndentedString(this.agreementLengthMax)).append("\n");
        sb.append("    agreementPeriod: ").append(this.toIndentedString((Object)this.agreementPeriod)).append("\n");
        sb.append("    overdraftInterestChargingCoverage: ").append(this.toIndentedString((Object)this.overdraftInterestChargingCoverage)).append("\n");
        sb.append("    bankGuaranteedIndicator: ").append(this.toIndentedString(this.bankGuaranteedIndicator)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftFeesCharges: ").append(this.toIndentedString(this.overdraftFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OverdraftInterestChargingCoverageEnum {
        INBA("INBA"),
        INTI("INTI"),
        INWH("INWH");

        private String value;

        private OverdraftInterestChargingCoverageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OverdraftInterestChargingCoverageEnum fromValue(String text) {
            for (OverdraftInterestChargingCoverageEnum b : OverdraftInterestChargingCoverageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum AgreementPeriodEnum {
        PACT("PACT"),
        PDAY("PDAY"),
        PHYR("PHYR"),
        PMTH("PMTH"),
        PQTR("PQTR"),
        PWEK("PWEK"),
        PYER("PYER");

        private String value;

        private AgreementPeriodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AgreementPeriodEnum fromValue(String text) {
            for (AgreementPeriodEnum b : AgreementPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

