/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import uk.org.openbanking.datamodel.account.OBOtherCodeType10;

public class OBReadProduct2DataOtherProductTypeProductDetails {
    @JsonProperty(value="Segment")
    private List<SegmentEnum> segment = null;
    @JsonProperty(value="FeeFreeLength")
    private Integer feeFreeLength = null;
    @JsonProperty(value="FeeFreeLengthPeriod")
    private FeeFreeLengthPeriodEnum feeFreeLengthPeriod = null;
    @JsonProperty(value="MonthlyMaximumCharge")
    private String monthlyMaximumCharge = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherSegment")
    private OBOtherCodeType10 otherSegment = null;

    public OBReadProduct2DataOtherProductTypeProductDetails segment(List<SegmentEnum> segment) {
        this.segment = segment;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeProductDetails addSegmentItem(SegmentEnum segmentItem) {
        if (this.segment == null) {
            this.segment = new ArrayList<SegmentEnum>();
        }
        this.segment.add(segmentItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SegmentEnum> getSegment() {
        return this.segment;
    }

    public void setSegment(List<SegmentEnum> segment) {
        this.segment = segment;
    }

    public OBReadProduct2DataOtherProductTypeProductDetails feeFreeLength(Integer feeFreeLength) {
        this.feeFreeLength = feeFreeLength;
        return this;
    }

    @ApiModelProperty(value="The length/duration of the fee free period")
    public Integer getFeeFreeLength() {
        return this.feeFreeLength;
    }

    public void setFeeFreeLength(Integer feeFreeLength) {
        this.feeFreeLength = feeFreeLength;
    }

    public OBReadProduct2DataOtherProductTypeProductDetails feeFreeLengthPeriod(FeeFreeLengthPeriodEnum feeFreeLengthPeriod) {
        this.feeFreeLengthPeriod = feeFreeLengthPeriod;
        return this;
    }

    @ApiModelProperty(value="The unit of period (days, weeks, months etc.) of the promotional length")
    public FeeFreeLengthPeriodEnum getFeeFreeLengthPeriod() {
        return this.feeFreeLengthPeriod;
    }

    public void setFeeFreeLengthPeriod(FeeFreeLengthPeriodEnum feeFreeLengthPeriod) {
        this.feeFreeLengthPeriod = feeFreeLengthPeriod;
    }

    public OBReadProduct2DataOtherProductTypeProductDetails monthlyMaximumCharge(String monthlyMaximumCharge) {
        this.monthlyMaximumCharge = monthlyMaximumCharge;
        return this;
    }

    @Pattern(regexp="^(-?\\\\d{1,14}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(value="The maximum relevant charges that could accrue as defined fully in Part 7 of the CMA order")
    public String getMonthlyMaximumCharge() {
        return this.monthlyMaximumCharge;
    }

    public void setMonthlyMaximumCharge(String monthlyMaximumCharge) {
        this.monthlyMaximumCharge = monthlyMaximumCharge;
    }

    public OBReadProduct2DataOtherProductTypeProductDetails notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeProductDetails addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBReadProduct2DataOtherProductTypeProductDetails otherSegment(OBOtherCodeType10 otherSegment) {
        this.otherSegment = otherSegment;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType10 getOtherSegment() {
        return this.otherSegment;
    }

    public void setOtherSegment(OBOtherCodeType10 otherSegment) {
        this.otherSegment = otherSegment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataOtherProductTypeProductDetails obReadProduct2DataOtherProductTypeProductDetails = (OBReadProduct2DataOtherProductTypeProductDetails)o;
        return Objects.equals(this.segment, obReadProduct2DataOtherProductTypeProductDetails.segment) && Objects.equals(this.feeFreeLength, obReadProduct2DataOtherProductTypeProductDetails.feeFreeLength) && Objects.equals((Object)this.feeFreeLengthPeriod, (Object)obReadProduct2DataOtherProductTypeProductDetails.feeFreeLengthPeriod) && Objects.equals(this.monthlyMaximumCharge, obReadProduct2DataOtherProductTypeProductDetails.monthlyMaximumCharge) && Objects.equals(this.notes, obReadProduct2DataOtherProductTypeProductDetails.notes) && Objects.equals(this.otherSegment, obReadProduct2DataOtherProductTypeProductDetails.otherSegment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.segment, this.feeFreeLength, this.feeFreeLengthPeriod, this.monthlyMaximumCharge, this.notes, this.otherSegment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataOtherProductTypeProductDetails {\n");
        sb.append("    segment: ").append(this.toIndentedString(this.segment)).append("\n");
        sb.append("    feeFreeLength: ").append(this.toIndentedString(this.feeFreeLength)).append("\n");
        sb.append("    feeFreeLengthPeriod: ").append(this.toIndentedString((Object)this.feeFreeLengthPeriod)).append("\n");
        sb.append("    monthlyMaximumCharge: ").append(this.toIndentedString(this.monthlyMaximumCharge)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherSegment: ").append(this.toIndentedString(this.otherSegment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeeFreeLengthPeriodEnum {
        PACT("PACT"),
        PDAY("PDAY"),
        PHYR("PHYR"),
        PMTH("PMTH"),
        PQTR("PQTR"),
        PWEK("PWEK"),
        PYER("PYER");

        private String value;

        private FeeFreeLengthPeriodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeFreeLengthPeriodEnum fromValue(String text) {
            for (FeeFreeLengthPeriodEnum b : FeeFreeLengthPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum SegmentEnum {
        GEAS("GEAS"),
        GEBA("GEBA"),
        GEBR("GEBR"),
        GEBU("GEBU"),
        GECI("GECI"),
        GECS("GECS"),
        GEFB("GEFB"),
        GEFG("GEFG"),
        GEG("GEG"),
        GEGR("GEGR"),
        GEGS("GEGS"),
        GEOT("GEOT"),
        GEOV("GEOV"),
        GEPA("GEPA"),
        GEPR("GEPR"),
        GERE("GERE"),
        GEST("GEST"),
        GEYA("GEYA"),
        GEYO("GEYO"),
        PSCA("PSCA"),
        PSES("PSES"),
        PSNC("PSNC"),
        PSNP("PSNP"),
        PSRG("PSRG"),
        PSSS("PSSS"),
        PSST("PSST"),
        PSSW("PSSW");

        private String value;

        private SegmentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SegmentEnum fromValue(String text) {
            for (SegmentEnum b : SegmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

