/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.BCA;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductType;
import uk.org.openbanking.datamodel.account.PCA;

@ApiModel(description="Product details associated with the Account")
public class OBReadProduct2DataProduct {
    @JsonProperty(value="ProductName")
    private String productName = null;
    @JsonProperty(value="ProductId")
    private String productId = null;
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="SecondaryProductId")
    private String secondaryProductId = null;
    @JsonProperty(value="ProductType")
    private ProductTypeEnum productType = null;
    @JsonProperty(value="MarketingStateId")
    private String marketingStateId = null;
    @JsonProperty(value="OtherProductType")
    private OBReadProduct2DataOtherProductType otherProductType = null;
    @JsonProperty(value="BCA")
    private BCA BCA = null;
    @JsonProperty(value="PCA")
    private PCA PCA = null;

    public OBReadProduct2DataProduct productName(String productName) {
        this.productName = productName;
        return this;
    }

    @Size(min=1, max=350)
    @ApiModelProperty(value="The name of the Product used for marketing purposes from a customer perspective. I.e. what the customer would recognise.")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public OBReadProduct2DataProduct productId(String productId) {
        this.productId = productId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="The unique ID that has been internally assigned by the financial institution to each of the current account banking products they market to their retail and/or small to medium enterprise (SME) customers.")
    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public OBReadProduct2DataProduct accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="Account Identification of the customer for Product Details")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBReadProduct2DataProduct secondaryProductId(String secondaryProductId) {
        this.secondaryProductId = secondaryProductId;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="Any secondary Identification which  supports Product Identifier to uniquely identify the current account banking products.")
    public String getSecondaryProductId() {
        return this.secondaryProductId;
    }

    public void setSecondaryProductId(String secondaryProductId) {
        this.secondaryProductId = secondaryProductId;
    }

    public OBReadProduct2DataProduct productType(ProductTypeEnum productType) {
        this.productType = productType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Product type : Personal Current Account, Business Current Account")
    public ProductTypeEnum getProductType() {
        return this.productType;
    }

    public void setProductType(ProductTypeEnum productType) {
        this.productType = productType;
    }

    public OBReadProduct2DataProduct marketingStateId(String marketingStateId) {
        this.marketingStateId = marketingStateId;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Product Marketing State.")
    public String getMarketingStateId() {
        return this.marketingStateId;
    }

    public void setMarketingStateId(String marketingStateId) {
        this.marketingStateId = marketingStateId;
    }

    public OBReadProduct2DataProduct otherProductType(OBReadProduct2DataOtherProductType otherProductType) {
        this.otherProductType = otherProductType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBReadProduct2DataOtherProductType getOtherProductType() {
        return this.otherProductType;
    }

    public void setOtherProductType(OBReadProduct2DataOtherProductType otherProductType) {
        this.otherProductType = otherProductType;
    }

    public OBReadProduct2DataProduct BCA(BCA BCA2) {
        this.BCA = BCA2;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public BCA getBCA() {
        return this.BCA;
    }

    public void setBCA(BCA BCA2) {
        this.BCA = BCA2;
    }

    public OBReadProduct2DataProduct PCA(PCA PCA2) {
        this.PCA = PCA2;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public PCA getPCA() {
        return this.PCA;
    }

    public void setPCA(PCA PCA2) {
        this.PCA = PCA2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataProduct obReadProduct2DataProduct = (OBReadProduct2DataProduct)o;
        return Objects.equals(this.productName, obReadProduct2DataProduct.productName) && Objects.equals(this.productId, obReadProduct2DataProduct.productId) && Objects.equals(this.accountId, obReadProduct2DataProduct.accountId) && Objects.equals(this.secondaryProductId, obReadProduct2DataProduct.secondaryProductId) && Objects.equals((Object)this.productType, (Object)obReadProduct2DataProduct.productType) && Objects.equals(this.marketingStateId, obReadProduct2DataProduct.marketingStateId) && Objects.equals(this.otherProductType, obReadProduct2DataProduct.otherProductType) && Objects.equals(this.BCA, obReadProduct2DataProduct.BCA) && Objects.equals(this.PCA, obReadProduct2DataProduct.PCA);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.productName, this.productId, this.accountId, this.secondaryProductId, this.productType, this.marketingStateId, this.otherProductType, this.BCA, this.PCA});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataProduct {\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    secondaryProductId: ").append(this.toIndentedString(this.secondaryProductId)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    marketingStateId: ").append(this.toIndentedString(this.marketingStateId)).append("\n");
        sb.append("    otherProductType: ").append(this.toIndentedString(this.otherProductType)).append("\n");
        sb.append("    BCA: ").append(this.toIndentedString(this.BCA)).append("\n");
        sb.append("    PCA: ").append(this.toIndentedString(this.PCA)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProductTypeEnum {
        BUSINESSCURRENTACCOUNT("BusinessCurrentAccount"),
        COMMERCIALCREDITCARD("CommercialCreditCard"),
        OTHER("Other"),
        PERSONALCURRENTACCOUNT("PersonalCurrentAccount"),
        SMELOAN("SMELoan");

        private String value;

        private ProductTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ProductTypeEnum fromValue(String text) {
            for (ProductTypeEnum b : ProductTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

