/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.account.OBExternalScheduleType1Code;

public class OBScheduledPayment2Basic {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="ScheduledPaymentId")
    private String scheduledPaymentId = null;
    @JsonProperty(value="ScheduledPaymentDateTime")
    private DateTime scheduledPaymentDateTime = null;
    @JsonProperty(value="ScheduledType")
    private OBExternalScheduleType1Code scheduledType = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;

    public OBScheduledPayment2Basic accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBScheduledPayment2Basic scheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="A unique and immutable identifier used to identify the scheduled payment resource. This identifier has no meaning to the account owner.")
    public String getScheduledPaymentId() {
        return this.scheduledPaymentId;
    }

    public void setScheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
    }

    public OBScheduledPayment2Basic scheduledPaymentDateTime(DateTime scheduledPaymentDateTime) {
        this.scheduledPaymentDateTime = scheduledPaymentDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The date on which the scheduled payment will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getScheduledPaymentDateTime() {
        return this.scheduledPaymentDateTime;
    }

    public void setScheduledPaymentDateTime(DateTime scheduledPaymentDateTime) {
        this.scheduledPaymentDateTime = scheduledPaymentDateTime;
    }

    public OBScheduledPayment2Basic scheduledType(OBExternalScheduleType1Code scheduledType) {
        this.scheduledType = scheduledType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalScheduleType1Code getScheduledType() {
        return this.scheduledType;
    }

    public void setScheduledType(OBExternalScheduleType1Code scheduledType) {
        this.scheduledType = scheduledType;
    }

    public OBScheduledPayment2Basic reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBScheduledPayment2Basic instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBScheduledPayment2Basic obScheduledPayment2Basic = (OBScheduledPayment2Basic)o;
        return Objects.equals(this.accountId, obScheduledPayment2Basic.accountId) && Objects.equals(this.scheduledPaymentId, obScheduledPayment2Basic.scheduledPaymentId) && Objects.equals(this.scheduledPaymentDateTime, obScheduledPayment2Basic.scheduledPaymentDateTime) && Objects.equals((Object)this.scheduledType, (Object)obScheduledPayment2Basic.scheduledType) && Objects.equals(this.reference, obScheduledPayment2Basic.reference) && Objects.equals(this.instructedAmount, obScheduledPayment2Basic.instructedAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.scheduledPaymentId, this.scheduledPaymentDateTime, this.scheduledType, this.reference, this.instructedAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBScheduledPayment2Basic {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    scheduledPaymentId: ").append(this.toIndentedString(this.scheduledPaymentId)).append("\n");
        sb.append("    scheduledPaymentDateTime: ").append(this.toIndentedString(this.scheduledPaymentDateTime)).append("\n");
        sb.append("    scheduledType: ").append(this.toIndentedString((Object)this.scheduledType)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

