/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification5;
import uk.org.openbanking.datamodel.account.OBCashAccount5;
import uk.org.openbanking.datamodel.account.OBExternalStandingOrderStatus1Code;
import uk.org.openbanking.datamodel.account.OBSupplementaryData1;

public class OBStandingOrder5Detail {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="StandingOrderId")
    private String standingOrderId = null;
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="FirstPaymentDateTime")
    private DateTime firstPaymentDateTime = null;
    @JsonProperty(value="NextPaymentDateTime")
    private DateTime nextPaymentDateTime = null;
    @JsonProperty(value="FinalPaymentDateTime")
    private DateTime finalPaymentDateTime = null;
    @JsonProperty(value="StandingOrderStatusCode")
    private OBExternalStandingOrderStatus1Code standingOrderStatusCode = null;
    @JsonProperty(value="FirstPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount = null;
    @JsonProperty(value="NextPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount = null;
    @JsonProperty(value="FinalPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification5 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount5 creditorAccount = null;

    public OBStandingOrder5Detail accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBStandingOrder5Detail standingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="A unique and immutable identifier used to identify the standing order resource. This identifier has no meaning to the account owner.")
    public String getStandingOrderId() {
        return this.standingOrderId;
    }

    public void setStandingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
    }

    public OBStandingOrder5Detail frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(EvryDay)$|^(EvryWorkgDay)$|^IntrvlDay:(0?[2-9]|[1-2][0-9]|3[0-1])$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Individual Definitions: EvryDay - Every day EvryWorkgDay - Every working day IntrvlDay - An interval specified in number of calendar days (02 to 31) IntrvlWkDay - An interval specified in weeks (01 to 09), and the day within the week (01 to 07) WkInMnthDay - A monthly interval, specifying the week of the month (01 to 05) and day within the week (01 to 07) IntrvlMnthDay - An interval specified in months (between 01 to 06, 12, 24), specifying the day within the month (-05 to -01, 01 to 31) QtrDay - Quarterly (either ENGLISH, SCOTTISH, or RECEIVED) ENGLISH = Paid on the 25th March, 24th June, 29th September and 25th December. SCOTTISH = Paid on the 2nd February, 15th May, 1st August and 11th November. RECEIVED = Paid on the 20th March, 19th June, 24th September and 20th December. Individual Patterns: EvryDay (ScheduleCode) EvryWorkgDay (ScheduleCode) IntrvlDay:NoOfDay (ScheduleCode + NoOfDay) IntrvlWkDay:IntervalInWeeks:DayInWeek (ScheduleCode + IntervalInWeeks + DayInWeek) WkInMnthDay:WeekInMonth:DayInWeek (ScheduleCode + WeekInMonth + DayInWeek) IntrvlMnthDay:IntervalInMonths:DayInMonth (ScheduleCode + IntervalInMonths + DayInMonth) QtrDay: + either (ENGLISH, SCOTTISH or RECEIVED) ScheduleCode + QuarterDay The regular expression for this element combines five smaller versions for each permitted pattern. To aid legibility - the components are presented individually here: EvryDay EvryWorkgDay IntrvlDay:((0[2-9])|([1-2][0-9])|3[0-1]) IntrvlWkDay:0[1-9]:0[1-7] WkInMnthDay:0[1-5]:0[1-7] IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]) QtrDay:(ENGLISH|SCOTTISH|RECEIVED) Full Regular Expression: ^(EvryDay)$|^(EvryWorkgDay)$|^IntrvlDay:(0?[2-9]|[1-2][0-9]|3[0-1])$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBStandingOrder5Detail reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBStandingOrder5Detail firstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The date on which the first payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getFirstPaymentDateTime() {
        return this.firstPaymentDateTime;
    }

    public void setFirstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
    }

    public OBStandingOrder5Detail nextPaymentDateTime(DateTime nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The date on which the next payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getNextPaymentDateTime() {
        return this.nextPaymentDateTime;
    }

    public void setNextPaymentDateTime(DateTime nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
    }

    public OBStandingOrder5Detail finalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="The date on which the final payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getFinalPaymentDateTime() {
        return this.finalPaymentDateTime;
    }

    public void setFinalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
    }

    public OBStandingOrder5Detail standingOrderStatusCode(OBExternalStandingOrderStatus1Code standingOrderStatusCode) {
        this.standingOrderStatusCode = standingOrderStatusCode;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBExternalStandingOrderStatus1Code getStandingOrderStatusCode() {
        return this.standingOrderStatusCode;
    }

    public void setStandingOrderStatusCode(OBExternalStandingOrderStatus1Code standingOrderStatusCode) {
        this.standingOrderStatusCode = standingOrderStatusCode;
    }

    public OBStandingOrder5Detail firstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBActiveOrHistoricCurrencyAndAmount getFirstPaymentAmount() {
        return this.firstPaymentAmount;
    }

    public void setFirstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
    }

    public OBStandingOrder5Detail nextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBActiveOrHistoricCurrencyAndAmount getNextPaymentAmount() {
        return this.nextPaymentAmount;
    }

    public void setNextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
    }

    public OBStandingOrder5Detail finalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBActiveOrHistoricCurrencyAndAmount getFinalPaymentAmount() {
        return this.finalPaymentAmount;
    }

    public void setFinalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
    }

    public OBStandingOrder5Detail supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public OBStandingOrder5Detail creditorAgent(OBBranchAndFinancialInstitutionIdentification5 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification5 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification5 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBStandingOrder5Detail creditorAccount(OBCashAccount5 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBCashAccount5 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount5 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStandingOrder5Detail obStandingOrder5Detail = (OBStandingOrder5Detail)o;
        return Objects.equals(this.accountId, obStandingOrder5Detail.accountId) && Objects.equals(this.standingOrderId, obStandingOrder5Detail.standingOrderId) && Objects.equals(this.frequency, obStandingOrder5Detail.frequency) && Objects.equals(this.reference, obStandingOrder5Detail.reference) && Objects.equals(this.firstPaymentDateTime, obStandingOrder5Detail.firstPaymentDateTime) && Objects.equals(this.nextPaymentDateTime, obStandingOrder5Detail.nextPaymentDateTime) && Objects.equals(this.finalPaymentDateTime, obStandingOrder5Detail.finalPaymentDateTime) && Objects.equals((Object)this.standingOrderStatusCode, (Object)obStandingOrder5Detail.standingOrderStatusCode) && Objects.equals(this.firstPaymentAmount, obStandingOrder5Detail.firstPaymentAmount) && Objects.equals(this.nextPaymentAmount, obStandingOrder5Detail.nextPaymentAmount) && Objects.equals(this.finalPaymentAmount, obStandingOrder5Detail.finalPaymentAmount) && Objects.equals(this.supplementaryData, obStandingOrder5Detail.supplementaryData) && Objects.equals(this.creditorAgent, obStandingOrder5Detail.creditorAgent) && Objects.equals(this.creditorAccount, obStandingOrder5Detail.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.standingOrderId, this.frequency, this.reference, this.firstPaymentDateTime, this.nextPaymentDateTime, this.finalPaymentDateTime, this.standingOrderStatusCode, this.firstPaymentAmount, this.nextPaymentAmount, this.finalPaymentAmount, this.supplementaryData, this.creditorAgent, this.creditorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStandingOrder5Detail {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    standingOrderId: ").append(this.toIndentedString(this.standingOrderId)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    firstPaymentDateTime: ").append(this.toIndentedString(this.firstPaymentDateTime)).append("\n");
        sb.append("    nextPaymentDateTime: ").append(this.toIndentedString(this.nextPaymentDateTime)).append("\n");
        sb.append("    finalPaymentDateTime: ").append(this.toIndentedString(this.finalPaymentDateTime)).append("\n");
        sb.append("    standingOrderStatusCode: ").append(this.toIndentedString((Object)this.standingOrderStatusCode)).append("\n");
        sb.append("    firstPaymentAmount: ").append(this.toIndentedString(this.firstPaymentAmount)).append("\n");
        sb.append("    nextPaymentAmount: ").append(this.toIndentedString(this.nextPaymentAmount)).append("\n");
        sb.append("    finalPaymentAmount: ").append(this.toIndentedString(this.finalPaymentAmount)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

