/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Set of elements used to provide details of a generic number value related to the statement resource.")
@Validated
public class OBStatementValue1 {
    @JsonProperty(value="Value")
    private Integer value = null;
    @JsonProperty(value="Type")
    private String type = null;

    public OBStatementValue1 value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Value associated with the statement value type.")
    @NotNull
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public OBStatementValue1 type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Statement value type, in a coded form.")
    @NotNull
    @Size(min=1, max=40)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStatementValue1 obStatementValue1 = (OBStatementValue1)o;
        return Objects.equals(this.value, obStatementValue1.value) && Objects.equals(this.type, obStatementValue1.type);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStatementValue1 {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

