/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBFrequency1Code;
import uk.org.openbanking.datamodel.account.OBInterestFixedVariableType1Code;
import uk.org.openbanking.datamodel.account.OBInterestRateType1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType1;
import uk.org.openbanking.datamodel.account.OBTierBandType1Code;

@ApiModel(description="Tier Band Details")
@Validated
public class OBTierBand1 {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMinimum")
    private String tierValueMinimum = null;
    @JsonProperty(value="TierValueMaximum")
    private String tierValueMaximum = null;
    @JsonProperty(value="CalculationFrequency")
    private OBFrequency1Code calculationFrequency = null;
    @JsonProperty(value="ApplicationFrequency")
    private OBFrequency1Code applicationFrequency = null;
    @JsonProperty(value="DepositInterestAppliedCoverage")
    private OBTierBandType1Code depositInterestAppliedCoverage = null;
    @JsonProperty(value="FixedVariableInterestRateType")
    private OBInterestFixedVariableType1Code fixedVariableInterestRateType = null;
    @JsonProperty(value="AER")
    private String aer = null;
    @JsonProperty(value="BankInterestRateType")
    private OBInterestRateType1Code bankInterestRateType = null;
    @JsonProperty(value="BankInterestRate")
    private String bankInterestRate = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="OBOtherCodeType1")
    private OBOtherCodeType1 otherBankInterestType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OBOtherCodeType1 otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OBOtherCodeType1 otherCalculationFrequency = null;

    public OBTierBand1 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a BCA.")
    @Size(min=1, max=35)
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBTierBand1 tierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
        return this;
    }

    @ApiModelProperty(required=true, value="Minimum deposit value for which the credit interest tier applies.")
    @NotNull
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getTierValueMinimum() {
        return this.tierValueMinimum;
    }

    public void setTierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
    }

    public OBTierBand1 tierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
        return this;
    }

    @ApiModelProperty(value="Maximum deposit value for which the credit interest tier applies.")
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    public String getTierValueMaximum() {
        return this.tierValueMaximum;
    }

    public void setTierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
    }

    public OBTierBand1 calculationFrequency(OBFrequency1Code calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How often is credit interest calculated for the account.")
    public OBFrequency1Code getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(OBFrequency1Code calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public OBTierBand1 applicationFrequency(OBFrequency1Code applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @ApiModelProperty(required=true, value="How often is interest applied to the BCA for this tier/band i.e. how often the financial institution pays accumulated interest to the customer's BCA.")
    @NotNull
    public OBFrequency1Code getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(OBFrequency1Code applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public OBTierBand1 depositInterestAppliedCoverage(OBTierBandType1Code depositInterestAppliedCoverage) {
        this.depositInterestAppliedCoverage = depositInterestAppliedCoverage;
        return this;
    }

    @ApiModelProperty(value="Amount on which Interest applied.")
    public OBTierBandType1Code getDepositInterestAppliedCoverage() {
        return this.depositInterestAppliedCoverage;
    }

    public void setDepositInterestAppliedCoverage(OBTierBandType1Code depositInterestAppliedCoverage) {
        this.depositInterestAppliedCoverage = depositInterestAppliedCoverage;
    }

    public OBTierBand1 fixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of interest rate, Fixed or Variable")
    @NotNull
    public OBInterestFixedVariableType1Code getFixedVariableInterestRateType() {
        return this.fixedVariableInterestRateType;
    }

    public void setFixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
    }

    public OBTierBand1 aer(String aer) {
        this.aer = aer;
        return this;
    }

    @ApiModelProperty(required=true, value="The annual equivalent rate (AER) is interest that is calculated under the assumption that any interest paid is combined with the original balance and the next interest payment will be based on the slightly higher account balance. Overall, this means that interest can be compounded several times in a year depending on the number of times that interest payments are made.   Read more: Annual Equivalent Rate (AER) http://www.investopedia.com/terms/a/aer.asp#ixzz4gfR7IO1A")
    @NotNull
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    public String getAer() {
        return this.aer;
    }

    public void setAer(String aer) {
        this.aer = aer;
    }

    public OBTierBand1 bankInterestRateType(OBInterestRateType1Code bankInterestRateType) {
        this.bankInterestRateType = bankInterestRateType;
        return this;
    }

    @ApiModelProperty(value="Interest rate types, other than AER, which financial institutions may use to describe the annual interest rate payable to the BCA.")
    public OBInterestRateType1Code getBankInterestRateType() {
        return this.bankInterestRateType;
    }

    public void setBankInterestRateType(OBInterestRateType1Code bankInterestRateType) {
        this.bankInterestRateType = bankInterestRateType;
    }

    public OBTierBand1 bankInterestRate(String bankInterestRate) {
        this.bankInterestRate = bankInterestRate;
        return this;
    }

    @ApiModelProperty(value="Bank Interest for the BCA product")
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    public String getBankInterestRate() {
        return this.bankInterestRate;
    }

    public void setBankInterestRate(String bankInterestRate) {
        this.bankInterestRate = bankInterestRate;
    }

    public OBTierBand1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBTierBand1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier Band details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBTierBand1 otherBankInterestType(OBOtherCodeType1 otherBankInterestType) {
        this.otherBankInterestType = otherBankInterestType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherBankInterestType() {
        return this.otherBankInterestType;
    }

    public void setOtherBankInterestType(OBOtherCodeType1 otherBankInterestType) {
        this.otherBankInterestType = otherBankInterestType;
    }

    public OBTierBand1 otherApplicationFrequency(OBOtherCodeType1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OBOtherCodeType1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public OBTierBand1 otherCalculationFrequency(OBOtherCodeType1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBOtherCodeType1 getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OBOtherCodeType1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBTierBand1 creditInterest1TierBand = (OBTierBand1)o;
        return Objects.equals(this.identification, creditInterest1TierBand.identification) && Objects.equals(this.tierValueMinimum, creditInterest1TierBand.tierValueMinimum) && Objects.equals(this.tierValueMaximum, creditInterest1TierBand.tierValueMaximum) && Objects.equals((Object)this.calculationFrequency, (Object)creditInterest1TierBand.calculationFrequency) && Objects.equals((Object)this.applicationFrequency, (Object)creditInterest1TierBand.applicationFrequency) && Objects.equals((Object)this.depositInterestAppliedCoverage, (Object)creditInterest1TierBand.depositInterestAppliedCoverage) && Objects.equals((Object)this.fixedVariableInterestRateType, (Object)creditInterest1TierBand.fixedVariableInterestRateType) && Objects.equals(this.aer, creditInterest1TierBand.aer) && Objects.equals((Object)this.bankInterestRateType, (Object)creditInterest1TierBand.bankInterestRateType) && Objects.equals(this.bankInterestRate, creditInterest1TierBand.bankInterestRate) && Objects.equals(this.notes, creditInterest1TierBand.notes) && Objects.equals(this.otherBankInterestType, creditInterest1TierBand.otherBankInterestType) && Objects.equals(this.otherApplicationFrequency, creditInterest1TierBand.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, creditInterest1TierBand.otherCalculationFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMinimum, this.tierValueMaximum, this.calculationFrequency, this.applicationFrequency, this.depositInterestAppliedCoverage, this.fixedVariableInterestRateType, this.aer, this.bankInterestRateType, this.bankInterestRate, this.notes, this.otherBankInterestType, this.otherApplicationFrequency, this.otherCalculationFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBTierBand1 {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMinimum: ").append(this.toIndentedString(this.tierValueMinimum)).append("\n");
        sb.append("    tierValueMaximum: ").append(this.toIndentedString(this.tierValueMaximum)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    depositInterestAppliedCoverage: ").append(this.toIndentedString((Object)this.depositInterestAppliedCoverage)).append("\n");
        sb.append("    fixedVariableInterestRateType: ").append(this.toIndentedString((Object)this.fixedVariableInterestRateType)).append("\n");
        sb.append("    AER: ").append(this.toIndentedString(this.aer)).append("\n");
        sb.append("    bankInterestRateType: ").append(this.toIndentedString((Object)this.bankInterestRateType)).append("\n");
        sb.append("    bankInterestRate: ").append(this.toIndentedString(this.bankInterestRate)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherBankInterestType: ").append(this.toIndentedString(this.otherBankInterestType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

