/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.account.OBBankTransactionCodeStructure1;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification6;
import uk.org.openbanking.datamodel.account.OBCashAccount6;
import uk.org.openbanking.datamodel.account.OBCurrencyExchange5;
import uk.org.openbanking.datamodel.account.OBEntryStatus1Code;
import uk.org.openbanking.datamodel.account.OBMerchantDetails1;
import uk.org.openbanking.datamodel.account.OBSupplementaryData1;
import uk.org.openbanking.datamodel.account.OBTransaction5ProprietaryBankTransactionCode;
import uk.org.openbanking.datamodel.account.OBTransactionCardInstrument1;
import uk.org.openbanking.datamodel.account.OBTransactionCashBalance;

@ApiModel(description="Provides further details on an entry in the report.")
public class OBTransaction5Detail {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="TransactionId")
    private String transactionId = null;
    @JsonProperty(value="TransactionReference")
    private String transactionReference = null;
    @JsonProperty(value="StatementReference")
    private List<String> statementReference = null;
    @JsonProperty(value="CreditDebitIndicator")
    private CreditDebitIndicatorEnum creditDebitIndicator = null;
    @JsonProperty(value="Status")
    private OBEntryStatus1Code status = null;
    @JsonProperty(value="BookingDateTime")
    private DateTime bookingDateTime = null;
    @JsonProperty(value="ValueDateTime")
    private DateTime valueDateTime = null;
    @JsonProperty(value="AddressLine")
    private String addressLine = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;
    @JsonProperty(value="ChargeAmount")
    private OBActiveOrHistoricCurrencyAndAmount chargeAmount = null;
    @JsonProperty(value="CurrencyExchange")
    private OBCurrencyExchange5 currencyExchange = null;
    @JsonProperty(value="BankTransactionCode")
    private OBBankTransactionCodeStructure1 bankTransactionCode = null;
    @JsonProperty(value="ProprietaryBankTransactionCode")
    private OBTransaction5ProprietaryBankTransactionCode proprietaryBankTransactionCode = null;
    @JsonProperty(value="CardInstrument")
    private OBTransactionCardInstrument1 cardInstrument = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;
    @JsonProperty(value="TransactionInformation")
    private String transactionInformation = null;
    @JsonProperty(value="Balance")
    private OBTransactionCashBalance balance = null;
    @JsonProperty(value="MerchantDetails")
    private OBMerchantDetails1 merchantDetails = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification6 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount6 creditorAccount = null;
    @JsonProperty(value="DebtorAgent")
    private OBBranchAndFinancialInstitutionIdentification6 debtorAgent = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccount6 debtorAccount = null;

    public OBTransaction5Detail accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBTransaction5Detail transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Size(min=1, max=210)
    @ApiModelProperty(value="Unique identifier for the transaction within an servicing institution. This identifier is both unique and immutable.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public OBTransaction5Detail transactionReference(String transactionReference) {
        this.transactionReference = transactionReference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference for the transaction. This reference is optionally populated, and may as an example be the FPID in the Faster Payments context.")
    public String getTransactionReference() {
        return this.transactionReference;
    }

    public void setTransactionReference(String transactionReference) {
        this.transactionReference = transactionReference;
    }

    public OBTransaction5Detail statementReference(List<String> statementReference) {
        this.statementReference = statementReference;
        return this;
    }

    public OBTransaction5Detail addStatementReferenceItem(String statementReferenceItem) {
        if (this.statementReference == null) {
            this.statementReference = new ArrayList<String>();
        }
        this.statementReference.add(statementReferenceItem);
        return this;
    }

    @ApiModelProperty(value="Unique reference for the statement. This reference may be optionally populated if available.")
    public List<String> getStatementReference() {
        return this.statementReference;
    }

    public void setStatementReference(List<String> statementReference) {
        this.statementReference = statementReference;
    }

    public OBTransaction5Detail creditDebitIndicator(CreditDebitIndicatorEnum creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Indicates whether the transaction is a credit or a debit entry.")
    public CreditDebitIndicatorEnum getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(CreditDebitIndicatorEnum creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBTransaction5Detail status(OBEntryStatus1Code status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBEntryStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBEntryStatus1Code status) {
        this.status = status;
    }

    public OBTransaction5Detail bookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = bookingDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time when a transaction entry is posted to an account on the account servicer's books. Usage: Booking date is the expected booking date, unless the status is booked, in which case it is the actual booking date. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getBookingDateTime() {
        return this.bookingDateTime;
    }

    public void setBookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = bookingDateTime;
    }

    public OBTransaction5Detail valueDateTime(DateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Date and time at which assets become available to the account owner in case of a credit entry, or cease to be available to the account owner in case of a debit transaction entry. Usage: If transaction entry status is pending and value date is present, then the value date refers to an expected/requested value date. For transaction entries subject to availability/float and for which availability information is provided, the value date must not be used. In this case the availability component identifies the number of availability days. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(DateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    public OBTransaction5Detail addressLine(String addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    @Size(min=1, max=70)
    @ApiModelProperty(value="Information that locates and identifies a specific address for a transaction entry, that is presented in free format text.")
    public String getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(String addressLine) {
        this.addressLine = addressLine;
    }

    public OBTransaction5Detail amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public OBTransaction5Detail chargeAmount(OBActiveOrHistoricCurrencyAndAmount chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBActiveOrHistoricCurrencyAndAmount getChargeAmount() {
        return this.chargeAmount;
    }

    public void setChargeAmount(OBActiveOrHistoricCurrencyAndAmount chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public OBTransaction5Detail currencyExchange(OBCurrencyExchange5 currencyExchange) {
        this.currencyExchange = currencyExchange;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBCurrencyExchange5 getCurrencyExchange() {
        return this.currencyExchange;
    }

    public void setCurrencyExchange(OBCurrencyExchange5 currencyExchange) {
        this.currencyExchange = currencyExchange;
    }

    public OBTransaction5Detail bankTransactionCode(OBBankTransactionCodeStructure1 bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBankTransactionCodeStructure1 getBankTransactionCode() {
        return this.bankTransactionCode;
    }

    public void setBankTransactionCode(OBBankTransactionCodeStructure1 bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
    }

    public OBTransaction5Detail proprietaryBankTransactionCode(OBTransaction5ProprietaryBankTransactionCode proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBTransaction5ProprietaryBankTransactionCode getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setProprietaryBankTransactionCode(OBTransaction5ProprietaryBankTransactionCode proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public OBTransaction5Detail cardInstrument(OBTransactionCardInstrument1 cardInstrument) {
        this.cardInstrument = cardInstrument;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBTransactionCardInstrument1 getCardInstrument() {
        return this.cardInstrument;
    }

    public void setCardInstrument(OBTransactionCardInstrument1 cardInstrument) {
        this.cardInstrument = cardInstrument;
    }

    public OBTransaction5Detail supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public OBTransaction5Detail transactionInformation(String transactionInformation) {
        this.transactionInformation = transactionInformation;
        return this;
    }

    @Size(min=1, max=500)
    @ApiModelProperty(value="")
    public String getTransactionInformation() {
        return this.transactionInformation;
    }

    public void setTransactionInformation(String transactionInformation) {
        this.transactionInformation = transactionInformation;
    }

    public OBTransaction5Detail balance(OBTransactionCashBalance balance) {
        this.balance = balance;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBTransactionCashBalance getBalance() {
        return this.balance;
    }

    public void setBalance(OBTransactionCashBalance balance) {
        this.balance = balance;
    }

    public OBTransaction5Detail merchantDetails(OBMerchantDetails1 merchantDetails) {
        this.merchantDetails = merchantDetails;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBMerchantDetails1 getMerchantDetails() {
        return this.merchantDetails;
    }

    public void setMerchantDetails(OBMerchantDetails1 merchantDetails) {
        this.merchantDetails = merchantDetails;
    }

    public OBTransaction5Detail creditorAgent(OBBranchAndFinancialInstitutionIdentification6 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification6 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification6 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBTransaction5Detail creditorAccount(OBCashAccount6 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBCashAccount6 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount6 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBTransaction5Detail debtorAgent(OBBranchAndFinancialInstitutionIdentification6 debtorAgent) {
        this.debtorAgent = debtorAgent;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification6 getDebtorAgent() {
        return this.debtorAgent;
    }

    public void setDebtorAgent(OBBranchAndFinancialInstitutionIdentification6 debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public OBTransaction5Detail debtorAccount(OBCashAccount6 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBCashAccount6 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccount6 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBTransaction5Detail obTransaction5Detail = (OBTransaction5Detail)o;
        return Objects.equals(this.accountId, obTransaction5Detail.accountId) && Objects.equals(this.transactionId, obTransaction5Detail.transactionId) && Objects.equals(this.transactionReference, obTransaction5Detail.transactionReference) && Objects.equals(this.statementReference, obTransaction5Detail.statementReference) && Objects.equals((Object)this.creditDebitIndicator, (Object)obTransaction5Detail.creditDebitIndicator) && Objects.equals((Object)this.status, (Object)obTransaction5Detail.status) && Objects.equals(this.bookingDateTime, obTransaction5Detail.bookingDateTime) && Objects.equals(this.valueDateTime, obTransaction5Detail.valueDateTime) && Objects.equals(this.addressLine, obTransaction5Detail.addressLine) && Objects.equals(this.amount, obTransaction5Detail.amount) && Objects.equals(this.chargeAmount, obTransaction5Detail.chargeAmount) && Objects.equals(this.currencyExchange, obTransaction5Detail.currencyExchange) && Objects.equals(this.bankTransactionCode, obTransaction5Detail.bankTransactionCode) && Objects.equals(this.proprietaryBankTransactionCode, obTransaction5Detail.proprietaryBankTransactionCode) && Objects.equals(this.cardInstrument, obTransaction5Detail.cardInstrument) && Objects.equals(this.supplementaryData, obTransaction5Detail.supplementaryData) && Objects.equals(this.transactionInformation, obTransaction5Detail.transactionInformation) && Objects.equals(this.balance, obTransaction5Detail.balance) && Objects.equals(this.merchantDetails, obTransaction5Detail.merchantDetails) && Objects.equals(this.creditorAgent, obTransaction5Detail.creditorAgent) && Objects.equals(this.creditorAccount, obTransaction5Detail.creditorAccount) && Objects.equals(this.debtorAgent, obTransaction5Detail.debtorAgent) && Objects.equals(this.debtorAccount, obTransaction5Detail.debtorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.transactionId, this.transactionReference, this.statementReference, this.creditDebitIndicator, this.status, this.bookingDateTime, this.valueDateTime, this.addressLine, this.amount, this.chargeAmount, this.currencyExchange, this.bankTransactionCode, this.proprietaryBankTransactionCode, this.cardInstrument, this.supplementaryData, this.transactionInformation, this.balance, this.merchantDetails, this.creditorAgent, this.creditorAccount, this.debtorAgent, this.debtorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBTransaction5Detail {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionReference: ").append(this.toIndentedString(this.transactionReference)).append("\n");
        sb.append("    statementReference: ").append(this.toIndentedString(this.statementReference)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    bookingDateTime: ").append(this.toIndentedString(this.bookingDateTime)).append("\n");
        sb.append("    valueDateTime: ").append(this.toIndentedString(this.valueDateTime)).append("\n");
        sb.append("    addressLine: ").append(this.toIndentedString(this.addressLine)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    chargeAmount: ").append(this.toIndentedString(this.chargeAmount)).append("\n");
        sb.append("    currencyExchange: ").append(this.toIndentedString(this.currencyExchange)).append("\n");
        sb.append("    bankTransactionCode: ").append(this.toIndentedString(this.bankTransactionCode)).append("\n");
        sb.append("    proprietaryBankTransactionCode: ").append(this.toIndentedString(this.proprietaryBankTransactionCode)).append("\n");
        sb.append("    cardInstrument: ").append(this.toIndentedString(this.cardInstrument)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("    transactionInformation: ").append(this.toIndentedString(this.transactionInformation)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    merchantDetails: ").append(this.toIndentedString(this.merchantDetails)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    debtorAgent: ").append(this.toIndentedString(this.debtorAgent)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CreditDebitIndicatorEnum {
        CREDIT("Credit"),
        DEBIT("Debit");

        private String value;

        private CreditDebitIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreditDebitIndicatorEnum fromValue(String text) {
            for (CreditDebitIndicatorEnum b : CreditDebitIndicatorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

