/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBExternalCardAuthorisationType1Code;
import uk.org.openbanking.datamodel.account.OBExternalCardSchemeType1Code;

@ApiModel(description="Set of elements to describe the card instrument used in the transaction.")
@Validated
public class OBTransactionCardInstrument1 {
    @JsonProperty(value="CardSchemeName")
    private OBExternalCardSchemeType1Code cardSchemeName = null;
    @JsonProperty(value="AuthorisationType")
    private OBExternalCardAuthorisationType1Code authorisationType = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="Identification")
    private String identification = null;

    public OBTransactionCardInstrument1 cardSchemeName(OBExternalCardSchemeType1Code cardSchemeName) {
        this.cardSchemeName = cardSchemeName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalCardSchemeType1Code getCardSchemeName() {
        return this.cardSchemeName;
    }

    public void setCardSchemeName(OBExternalCardSchemeType1Code cardSchemeName) {
        this.cardSchemeName = cardSchemeName;
    }

    public OBTransactionCardInstrument1 authorisationType(OBExternalCardAuthorisationType1Code authorisationType) {
        this.authorisationType = authorisationType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExternalCardAuthorisationType1Code getAuthorisationType() {
        return this.authorisationType;
    }

    public void setAuthorisationType(OBExternalCardAuthorisationType1Code authorisationType) {
        this.authorisationType = authorisationType;
    }

    public OBTransactionCardInstrument1 name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the cardholder using the card instrument.")
    @Size(min=1, max=70)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBTransactionCardInstrument1 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(value="Identification assigned by an institution to identify the card instrument used in the transaction. This identification is known by the account owner, and may be masked.")
    @Size(min=1, max=34)
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBTransactionCardInstrument1 obTransactionCardInstrument1 = (OBTransactionCardInstrument1)o;
        return Objects.equals((Object)this.cardSchemeName, (Object)obTransactionCardInstrument1.cardSchemeName) && Objects.equals((Object)this.authorisationType, (Object)obTransactionCardInstrument1.authorisationType) && Objects.equals(this.name, obTransactionCardInstrument1.name) && Objects.equals(this.identification, obTransactionCardInstrument1.identification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardSchemeName, this.authorisationType, this.name, this.identification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBTransactionCardInstrument1 {\n");
        sb.append("    cardSchemeName: ").append(this.toIndentedString((Object)this.cardSchemeName)).append("\n");
        sb.append("    authorisationType: ").append(this.toIndentedString((Object)this.authorisationType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

