/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@ApiModel(description="Other Fee/charge type which is not available in the standard code set")
public class OtherFeeType1 {
    @JsonProperty(value="Code")
    private String code = null;
    @JsonProperty(value="FeeCategory")
    private FeeCategoryEnum feeCategory = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="Description")
    private String description = null;

    public OtherFeeType1 code(String code) {
        this.code = code;
        return this;
    }

    @Pattern(regexp="^\\w{0,4}$")
    @Size(min=0, max=4)
    @ApiModelProperty(value="The four letter Mnemonic used within an XML file to identify a code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public OtherFeeType1 feeCategory(FeeCategoryEnum feeCategory) {
        this.feeCategory = feeCategory;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Categorisation of fees and charges into standard categories.")
    public FeeCategoryEnum getFeeCategory() {
        return this.feeCategory;
    }

    public void setFeeCategory(FeeCategoryEnum feeCategory) {
        this.feeCategory = feeCategory;
    }

    public OtherFeeType1 name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Size(min=1, max=70)
    @ApiModelProperty(required=true, value="Long name associated with the code")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OtherFeeType1 description(String description) {
        this.description = description;
        return this;
    }

    @NotNull
    @Size(min=1, max=350)
    @ApiModelProperty(required=true, value="Description to describe the purpose of the code")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtherFeeType1 otherFeeType1 = (OtherFeeType1)o;
        return Objects.equals(this.code, otherFeeType1.code) && Objects.equals((Object)this.feeCategory, (Object)otherFeeType1.feeCategory) && Objects.equals(this.name, otherFeeType1.name) && Objects.equals(this.description, otherFeeType1.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.feeCategory, this.name, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtherFeeType1 {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    feeCategory: ").append(this.toIndentedString((Object)this.feeCategory)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeeCategoryEnum {
        OTHER("Other"),
        SERVICING("Servicing");

        private String value;

        private FeeCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeCategoryEnum fromValue(String text) {
            for (FeeCategoryEnum b : FeeCategoryEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

