/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import uk.org.openbanking.datamodel.account.FeeApplicableRange;
import uk.org.openbanking.datamodel.account.OtherApplicationFrequency1;
import uk.org.openbanking.datamodel.account.OtherCalculationFrequency1;
import uk.org.openbanking.datamodel.account.OtherFeeCategoryType;
import uk.org.openbanking.datamodel.account.OtherFeeRateType1;
import uk.org.openbanking.datamodel.account.OtherFeeType1;
import uk.org.openbanking.datamodel.account.OtherFeesChargesFeeChargeCap;

@ApiModel(description="Other fees/charges details")
public class OtherFeesChargesFeeChargeDetail {
    @JsonProperty(value="FeeCategory")
    private FeeCategoryEnum feeCategory = null;
    @JsonProperty(value="FeeType")
    private FeeTypeEnum feeType = null;
    @JsonProperty(value="FeeAmount")
    private String feeAmount = null;
    @JsonProperty(value="FeeRate")
    private String feeRate = null;
    @JsonProperty(value="FeeRateType")
    private FeeRateTypeEnum feeRateType = null;
    @JsonProperty(value="ApplicationFrequency")
    private ApplicationFrequencyEnum applicationFrequency = null;
    @JsonProperty(value="CalculationFrequency")
    private CalculationFrequencyEnum calculationFrequency = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherFeeCategoryType")
    private OtherFeeCategoryType otherFeeCategoryType = null;
    @JsonProperty(value="OtherFeeType")
    private OtherFeeType1 otherFeeType = null;
    @JsonProperty(value="OtherFeeRateType")
    private OtherFeeRateType1 otherFeeRateType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OtherApplicationFrequency1 otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OtherCalculationFrequency1 otherCalculationFrequency = null;
    @JsonProperty(value="FeeChargeCap")
    private List<OtherFeesChargesFeeChargeCap> feeChargeCap = null;
    @JsonProperty(value="FeeApplicableRange")
    private FeeApplicableRange feeApplicableRange = null;

    public OtherFeesChargesFeeChargeDetail feeCategory(FeeCategoryEnum feeCategory) {
        this.feeCategory = feeCategory;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Categorisation of fees and charges into standard categories.")
    public FeeCategoryEnum getFeeCategory() {
        return this.feeCategory;
    }

    public void setFeeCategory(FeeCategoryEnum feeCategory) {
        this.feeCategory = feeCategory;
    }

    public OtherFeesChargesFeeChargeDetail feeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Fee/Charge Type")
    public FeeTypeEnum getFeeType() {
        return this.feeType;
    }

    public void setFeeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
    }

    public OtherFeesChargesFeeChargeDetail feeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Fee Amount charged for a fee/charge (where it is charged in terms of an amount rather than a rate)")
    public String getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
    }

    public OtherFeesChargesFeeChargeDetail feeRate(String feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Rate charged for Fee/Charge (where it is charged in terms of a rate rather than an amount)")
    public String getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(String feeRate) {
        this.feeRate = feeRate;
    }

    public OtherFeesChargesFeeChargeDetail feeRateType(FeeRateTypeEnum feeRateType) {
        this.feeRateType = feeRateType;
        return this;
    }

    @ApiModelProperty(value="Rate type for Fee/Charge (where it is charged in terms of a rate rather than an amount)")
    public FeeRateTypeEnum getFeeRateType() {
        return this.feeRateType;
    }

    public void setFeeRateType(FeeRateTypeEnum feeRateType) {
        this.feeRateType = feeRateType;
    }

    public OtherFeesChargesFeeChargeDetail applicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="How frequently the fee/charge is applied to the account")
    public ApplicationFrequencyEnum getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public OtherFeesChargesFeeChargeDetail calculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How frequently the fee/charge is calculated")
    public CalculationFrequencyEnum getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public OtherFeesChargesFeeChargeDetail notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OtherFeesChargesFeeChargeDetail addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the fee/charge details.")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OtherFeesChargesFeeChargeDetail otherFeeCategoryType(OtherFeeCategoryType otherFeeCategoryType) {
        this.otherFeeCategoryType = otherFeeCategoryType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeCategoryType getOtherFeeCategoryType() {
        return this.otherFeeCategoryType;
    }

    public void setOtherFeeCategoryType(OtherFeeCategoryType otherFeeCategoryType) {
        this.otherFeeCategoryType = otherFeeCategoryType;
    }

    public OtherFeesChargesFeeChargeDetail otherFeeType(OtherFeeType1 otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeType1 getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(OtherFeeType1 otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public OtherFeesChargesFeeChargeDetail otherFeeRateType(OtherFeeRateType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeRateType1 getOtherFeeRateType() {
        return this.otherFeeRateType;
    }

    public void setOtherFeeRateType(OtherFeeRateType1 otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
    }

    public OtherFeesChargesFeeChargeDetail otherApplicationFrequency(OtherApplicationFrequency1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherApplicationFrequency1 getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OtherApplicationFrequency1 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public OtherFeesChargesFeeChargeDetail otherCalculationFrequency(OtherCalculationFrequency1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherCalculationFrequency1 getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OtherCalculationFrequency1 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public OtherFeesChargesFeeChargeDetail feeChargeCap(List<OtherFeesChargesFeeChargeCap> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
        return this;
    }

    public OtherFeesChargesFeeChargeDetail addFeeChargeCapItem(OtherFeesChargesFeeChargeCap feeChargeCapItem) {
        if (this.feeChargeCap == null) {
            this.feeChargeCap = new ArrayList<OtherFeesChargesFeeChargeCap>();
        }
        this.feeChargeCap.add(feeChargeCapItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Details about any caps (maximum charges) that apply to a particular fee/charge")
    public List<OtherFeesChargesFeeChargeCap> getFeeChargeCap() {
        return this.feeChargeCap;
    }

    public void setFeeChargeCap(List<OtherFeesChargesFeeChargeCap> feeChargeCap) {
        this.feeChargeCap = feeChargeCap;
    }

    public OtherFeesChargesFeeChargeDetail feeApplicableRange(FeeApplicableRange feeApplicableRange) {
        this.feeApplicableRange = feeApplicableRange;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public FeeApplicableRange getFeeApplicableRange() {
        return this.feeApplicableRange;
    }

    public void setFeeApplicableRange(FeeApplicableRange feeApplicableRange) {
        this.feeApplicableRange = feeApplicableRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtherFeesChargesFeeChargeDetail otherFeesChargesFeeChargeDetail = (OtherFeesChargesFeeChargeDetail)o;
        return Objects.equals((Object)this.feeCategory, (Object)otherFeesChargesFeeChargeDetail.feeCategory) && Objects.equals((Object)this.feeType, (Object)otherFeesChargesFeeChargeDetail.feeType) && Objects.equals(this.feeAmount, otherFeesChargesFeeChargeDetail.feeAmount) && Objects.equals(this.feeRate, otherFeesChargesFeeChargeDetail.feeRate) && Objects.equals((Object)this.feeRateType, (Object)otherFeesChargesFeeChargeDetail.feeRateType) && Objects.equals((Object)this.applicationFrequency, (Object)otherFeesChargesFeeChargeDetail.applicationFrequency) && Objects.equals((Object)this.calculationFrequency, (Object)otherFeesChargesFeeChargeDetail.calculationFrequency) && Objects.equals(this.notes, otherFeesChargesFeeChargeDetail.notes) && Objects.equals(this.otherFeeCategoryType, otherFeesChargesFeeChargeDetail.otherFeeCategoryType) && Objects.equals(this.otherFeeType, otherFeesChargesFeeChargeDetail.otherFeeType) && Objects.equals(this.otherFeeRateType, otherFeesChargesFeeChargeDetail.otherFeeRateType) && Objects.equals(this.otherApplicationFrequency, otherFeesChargesFeeChargeDetail.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, otherFeesChargesFeeChargeDetail.otherCalculationFrequency) && Objects.equals(this.feeChargeCap, otherFeesChargesFeeChargeDetail.feeChargeCap) && Objects.equals(this.feeApplicableRange, otherFeesChargesFeeChargeDetail.feeApplicableRange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeCategory, this.feeType, this.feeAmount, this.feeRate, this.feeRateType, this.applicationFrequency, this.calculationFrequency, this.notes, this.otherFeeCategoryType, this.otherFeeType, this.otherFeeRateType, this.otherApplicationFrequency, this.otherCalculationFrequency, this.feeChargeCap, this.feeApplicableRange});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtherFeesChargesFeeChargeDetail {\n");
        sb.append("    feeCategory: ").append(this.toIndentedString((Object)this.feeCategory)).append("\n");
        sb.append("    feeType: ").append(this.toIndentedString((Object)this.feeType)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    feeRateType: ").append(this.toIndentedString((Object)this.feeRateType)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherFeeCategoryType: ").append(this.toIndentedString(this.otherFeeCategoryType)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("    otherFeeRateType: ").append(this.toIndentedString(this.otherFeeRateType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("    feeChargeCap: ").append(this.toIndentedString(this.feeChargeCap)).append("\n");
        sb.append("    feeApplicableRange: ").append(this.toIndentedString(this.feeApplicableRange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalculationFrequencyEnum {
        ACCOUNTCLOSING("AccountClosing"),
        ACCOUNTOPENING("AccountOpening"),
        ACADEMICTERM("AcademicTerm"),
        CHARGINGPERIOD("ChargingPeriod"),
        DAILY("Daily"),
        PERITEM("PerItem"),
        MONTHLY("Monthly"),
        ONACCOUNTANNIVERSARY("OnAccountAnniversary"),
        OTHER("Other"),
        PERHOUR("PerHour"),
        PEROCCURRENCE("PerOccurrence"),
        PERSHEET("PerSheet"),
        PERTRANSACTION("PerTransaction"),
        PERTRANSACTIONAMOUNT("PerTransactionAmount"),
        PERTRANSACTIONPERCENTAGE("PerTransactionPercentage"),
        QUARTERLY("Quarterly"),
        SIXMONTHLY("SixMonthly"),
        STATEMENTMONTHLY("StatementMonthly"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private CalculationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CalculationFrequencyEnum fromValue(String text) {
            for (CalculationFrequencyEnum b : CalculationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ApplicationFrequencyEnum {
        ACCOUNTCLOSING("AccountClosing"),
        ACCOUNTOPENING("AccountOpening"),
        ACADEMICTERM("AcademicTerm"),
        CHARGINGPERIOD("ChargingPeriod"),
        DAILY("Daily"),
        PERITEM("PerItem"),
        MONTHLY("Monthly"),
        ONACCOUNTANNIVERSARY("OnAccountAnniversary"),
        OTHER("Other"),
        PERHOUR("PerHour"),
        PEROCCURRENCE("PerOccurrence"),
        PERSHEET("PerSheet"),
        PERTRANSACTION("PerTransaction"),
        PERTRANSACTIONAMOUNT("PerTransactionAmount"),
        PERTRANSACTIONPERCENTAGE("PerTransactionPercentage"),
        QUARTERLY("Quarterly"),
        SIXMONTHLY("SixMonthly"),
        STATEMENTMONTHLY("StatementMonthly"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private ApplicationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ApplicationFrequencyEnum fromValue(String text) {
            for (ApplicationFrequencyEnum b : ApplicationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeRateTypeEnum {
        LINKEDBASERATE("LinkedBaseRate"),
        GROSS("Gross"),
        NET("Net"),
        OTHER("Other");

        private String value;

        private FeeRateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeRateTypeEnum fromValue(String text) {
            for (FeeRateTypeEnum b : FeeRateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeTypeEnum {
        SERVICECACCOUNTFEE("ServiceCAccountFee"),
        SERVICECACCOUNTFEEMONTHLY("ServiceCAccountFeeMonthly"),
        SERVICECOTHER("ServiceCOther"),
        OTHER("Other");

        private String value;

        private FeeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeTypeEnum fromValue(String text) {
            for (FeeTypeEnum b : FeeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeCategoryEnum {
        OTHER("Other"),
        SERVICING("Servicing");

        private String value;

        private FeeCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeCategoryEnum fromValue(String text) {
            for (FeeCategoryEnum b : FeeCategoryEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

