/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.Overdraft1OverdraftFeesCharges;

@ApiModel(description="Provides overdraft details for a specific tier or band")
public class Overdraft1OverdraftTierBand {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMin")
    private String tierValueMin = null;
    @JsonProperty(value="TierValueMax")
    private String tierValueMax = null;
    @JsonProperty(value="OverdraftInterestChargingCoverage")
    private OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage = null;
    @JsonProperty(value="BankGuaranteedIndicator")
    private Boolean bankGuaranteedIndicator = null;
    @JsonProperty(value="EAR")
    private String EAR = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OverdraftFeesCharges")
    private List<Overdraft1OverdraftFeesCharges> overdraftFeesCharges = null;

    public Overdraft1OverdraftTierBand identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a overdraft.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public Overdraft1OverdraftTierBand tierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="Minimum value of Overdraft Tier/Band")
    public String getTierValueMin() {
        return this.tierValueMin;
    }

    public void setTierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
    }

    public Overdraft1OverdraftTierBand tierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Maximum value of Overdraft Tier/Band")
    public String getTierValueMax() {
        return this.tierValueMax;
    }

    public void setTierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
    }

    public Overdraft1OverdraftTierBand overdraftInterestChargingCoverage(OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
        return this;
    }

    @ApiModelProperty(value="Interest charged on whole amount or tiered/banded")
    public OverdraftInterestChargingCoverageEnum getOverdraftInterestChargingCoverage() {
        return this.overdraftInterestChargingCoverage;
    }

    public void setOverdraftInterestChargingCoverage(OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
    }

    public Overdraft1OverdraftTierBand bankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates that a bank provides the overdraft limit up to TierValueMIn to all customers automatically")
    public Boolean isBankGuaranteedIndicator() {
        return this.bankGuaranteedIndicator;
    }

    public void setBankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
    }

    public Overdraft1OverdraftTierBand EAR(String EAR) {
        this.EAR = EAR;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="EAR means Effective Annual Rate and/or Equivalent Annual Rate (frequently used interchangeably), being the actual annual interest rate of an Overdraft.")
    public String getEAR() {
        return this.EAR;
    }

    public void setEAR(String EAR) {
        this.EAR = EAR;
    }

    public Overdraft1OverdraftTierBand notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public Overdraft1OverdraftTierBand addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier/band details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public Overdraft1OverdraftTierBand overdraftFeesCharges(List<Overdraft1OverdraftFeesCharges> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
        return this;
    }

    public Overdraft1OverdraftTierBand addOverdraftFeesChargesItem(Overdraft1OverdraftFeesCharges overdraftFeesChargesItem) {
        if (this.overdraftFeesCharges == null) {
            this.overdraftFeesCharges = new ArrayList<Overdraft1OverdraftFeesCharges>();
        }
        this.overdraftFeesCharges.add(overdraftFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Overdraft fees and charges")
    public List<Overdraft1OverdraftFeesCharges> getOverdraftFeesCharges() {
        return this.overdraftFeesCharges;
    }

    public void setOverdraftFeesCharges(List<Overdraft1OverdraftFeesCharges> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Overdraft1OverdraftTierBand overdraft1OverdraftTierBand = (Overdraft1OverdraftTierBand)o;
        return Objects.equals(this.identification, overdraft1OverdraftTierBand.identification) && Objects.equals(this.tierValueMin, overdraft1OverdraftTierBand.tierValueMin) && Objects.equals(this.tierValueMax, overdraft1OverdraftTierBand.tierValueMax) && Objects.equals((Object)this.overdraftInterestChargingCoverage, (Object)overdraft1OverdraftTierBand.overdraftInterestChargingCoverage) && Objects.equals(this.bankGuaranteedIndicator, overdraft1OverdraftTierBand.bankGuaranteedIndicator) && Objects.equals(this.EAR, overdraft1OverdraftTierBand.EAR) && Objects.equals(this.notes, overdraft1OverdraftTierBand.notes) && Objects.equals(this.overdraftFeesCharges, overdraft1OverdraftTierBand.overdraftFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMin, this.tierValueMax, this.overdraftInterestChargingCoverage, this.bankGuaranteedIndicator, this.EAR, this.notes, this.overdraftFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Overdraft1OverdraftTierBand {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMin: ").append(this.toIndentedString(this.tierValueMin)).append("\n");
        sb.append("    tierValueMax: ").append(this.toIndentedString(this.tierValueMax)).append("\n");
        sb.append("    overdraftInterestChargingCoverage: ").append(this.toIndentedString((Object)this.overdraftInterestChargingCoverage)).append("\n");
        sb.append("    bankGuaranteedIndicator: ").append(this.toIndentedString(this.bankGuaranteedIndicator)).append("\n");
        sb.append("    EAR: ").append(this.toIndentedString(this.EAR)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftFeesCharges: ").append(this.toIndentedString(this.overdraftFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OverdraftInterestChargingCoverageEnum {
        TIERED("Tiered"),
        WHOLE("Whole");

        private String value;

        private OverdraftInterestChargingCoverageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OverdraftInterestChargingCoverageEnum fromValue(String text) {
            for (OverdraftInterestChargingCoverageEnum b : OverdraftInterestChargingCoverageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

