/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import uk.org.openbanking.datamodel.account.OtherApplicationFrequency;
import uk.org.openbanking.datamodel.account.OtherCalculationFrequency;
import uk.org.openbanking.datamodel.account.OtherFeeRateType;
import uk.org.openbanking.datamodel.account.OtherFeeType;
import uk.org.openbanking.datamodel.account.OverdraftOverdraftFeeChargeCap;

@ApiModel(description="Details about the fees/charges")
public class OverdraftOverdraftFeeChargeDetail {
    @JsonProperty(value="FeeType")
    private FeeTypeEnum feeType = null;
    @JsonProperty(value="NegotiableIndicator")
    private Boolean negotiableIndicator = null;
    @JsonProperty(value="OverdraftControlIndicator")
    private Boolean overdraftControlIndicator = null;
    @JsonProperty(value="IncrementalBorrowingAmount")
    private String incrementalBorrowingAmount = null;
    @JsonProperty(value="FeeAmount")
    private String feeAmount = null;
    @JsonProperty(value="FeeRate")
    private String feeRate = null;
    @JsonProperty(value="FeeRateType")
    private FeeRateTypeEnum feeRateType = null;
    @JsonProperty(value="ApplicationFrequency")
    private ApplicationFrequencyEnum applicationFrequency = null;
    @JsonProperty(value="CalculationFrequency")
    private CalculationFrequencyEnum calculationFrequency = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OverdraftFeeChargeCap")
    private List<OverdraftOverdraftFeeChargeCap> overdraftFeeChargeCap = null;
    @JsonProperty(value="OtherFeeType")
    private OtherFeeType otherFeeType = null;
    @JsonProperty(value="OtherFeeRateType")
    private OtherFeeRateType otherFeeRateType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OtherApplicationFrequency otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OtherCalculationFrequency otherCalculationFrequency = null;

    public OverdraftOverdraftFeeChargeDetail feeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Overdraft fee type")
    public FeeTypeEnum getFeeType() {
        return this.feeType;
    }

    public void setFeeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
    }

    public OverdraftOverdraftFeeChargeDetail negotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether fee and charges are negotiable")
    public Boolean isNegotiableIndicator() {
        return this.negotiableIndicator;
    }

    public void setNegotiableIndicator(Boolean negotiableIndicator) {
        this.negotiableIndicator = negotiableIndicator;
    }

    public OverdraftOverdraftFeeChargeDetail overdraftControlIndicator(Boolean overdraftControlIndicator) {
        this.overdraftControlIndicator = overdraftControlIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates if the fee/charge is already covered by an 'Overdraft Control' fee or not.")
    public Boolean isOverdraftControlIndicator() {
        return this.overdraftControlIndicator;
    }

    public void setOverdraftControlIndicator(Boolean overdraftControlIndicator) {
        this.overdraftControlIndicator = overdraftControlIndicator;
    }

    public OverdraftOverdraftFeeChargeDetail incrementalBorrowingAmount(String incrementalBorrowingAmount) {
        this.incrementalBorrowingAmount = incrementalBorrowingAmount;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Every additional tranche of an overdraft balance to which an overdraft fee is applied")
    public String getIncrementalBorrowingAmount() {
        return this.incrementalBorrowingAmount;
    }

    public void setIncrementalBorrowingAmount(String incrementalBorrowingAmount) {
        this.incrementalBorrowingAmount = incrementalBorrowingAmount;
    }

    public OverdraftOverdraftFeeChargeDetail feeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Amount charged for an overdraft fee/charge (where it is charged in terms of an amount rather than a rate)")
    public String getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(String feeAmount) {
        this.feeAmount = feeAmount;
    }

    public OverdraftOverdraftFeeChargeDetail feeRate(String feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Rate charged for overdraft fee/charge (where it is charged in terms of a rate rather than an amount)")
    public String getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(String feeRate) {
        this.feeRate = feeRate;
    }

    public OverdraftOverdraftFeeChargeDetail feeRateType(FeeRateTypeEnum feeRateType) {
        this.feeRateType = feeRateType;
        return this;
    }

    @ApiModelProperty(value="Rate type for overdraft fee/charge (where it is charged in terms of a rate rather than an amount)")
    public FeeRateTypeEnum getFeeRateType() {
        return this.feeRateType;
    }

    public void setFeeRateType(FeeRateTypeEnum feeRateType) {
        this.feeRateType = feeRateType;
    }

    public OverdraftOverdraftFeeChargeDetail applicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Frequency at which the overdraft charge is applied to the account")
    public ApplicationFrequencyEnum getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public OverdraftOverdraftFeeChargeDetail calculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How often is the overdraft fee/charge calculated for the account.")
    public CalculationFrequencyEnum getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public OverdraftOverdraftFeeChargeDetail notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OverdraftOverdraftFeeChargeDetail addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Free text for capturing any other info related to Overdraft Fees Charge Details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OverdraftOverdraftFeeChargeDetail overdraftFeeChargeCap(List<OverdraftOverdraftFeeChargeCap> overdraftFeeChargeCap) {
        this.overdraftFeeChargeCap = overdraftFeeChargeCap;
        return this;
    }

    public OverdraftOverdraftFeeChargeDetail addOverdraftFeeChargeCapItem(OverdraftOverdraftFeeChargeCap overdraftFeeChargeCapItem) {
        if (this.overdraftFeeChargeCap == null) {
            this.overdraftFeeChargeCap = new ArrayList<OverdraftOverdraftFeeChargeCap>();
        }
        this.overdraftFeeChargeCap.add(overdraftFeeChargeCapItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Details about any caps (maximum charges) that apply to a particular fee/charge. Capping can either be based on an amount (in gbp), an amount (in items) or a rate.")
    public List<OverdraftOverdraftFeeChargeCap> getOverdraftFeeChargeCap() {
        return this.overdraftFeeChargeCap;
    }

    public void setOverdraftFeeChargeCap(List<OverdraftOverdraftFeeChargeCap> overdraftFeeChargeCap) {
        this.overdraftFeeChargeCap = overdraftFeeChargeCap;
    }

    public OverdraftOverdraftFeeChargeDetail otherFeeType(OtherFeeType otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeType getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(OtherFeeType otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public OverdraftOverdraftFeeChargeDetail otherFeeRateType(OtherFeeRateType otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherFeeRateType getOtherFeeRateType() {
        return this.otherFeeRateType;
    }

    public void setOtherFeeRateType(OtherFeeRateType otherFeeRateType) {
        this.otherFeeRateType = otherFeeRateType;
    }

    public OverdraftOverdraftFeeChargeDetail otherApplicationFrequency(OtherApplicationFrequency otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherApplicationFrequency getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OtherApplicationFrequency otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public OverdraftOverdraftFeeChargeDetail otherCalculationFrequency(OtherCalculationFrequency otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OtherCalculationFrequency getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OtherCalculationFrequency otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverdraftOverdraftFeeChargeDetail overdraftOverdraftFeeChargeDetail = (OverdraftOverdraftFeeChargeDetail)o;
        return Objects.equals((Object)this.feeType, (Object)overdraftOverdraftFeeChargeDetail.feeType) && Objects.equals(this.negotiableIndicator, overdraftOverdraftFeeChargeDetail.negotiableIndicator) && Objects.equals(this.overdraftControlIndicator, overdraftOverdraftFeeChargeDetail.overdraftControlIndicator) && Objects.equals(this.incrementalBorrowingAmount, overdraftOverdraftFeeChargeDetail.incrementalBorrowingAmount) && Objects.equals(this.feeAmount, overdraftOverdraftFeeChargeDetail.feeAmount) && Objects.equals(this.feeRate, overdraftOverdraftFeeChargeDetail.feeRate) && Objects.equals((Object)this.feeRateType, (Object)overdraftOverdraftFeeChargeDetail.feeRateType) && Objects.equals((Object)this.applicationFrequency, (Object)overdraftOverdraftFeeChargeDetail.applicationFrequency) && Objects.equals((Object)this.calculationFrequency, (Object)overdraftOverdraftFeeChargeDetail.calculationFrequency) && Objects.equals(this.notes, overdraftOverdraftFeeChargeDetail.notes) && Objects.equals(this.overdraftFeeChargeCap, overdraftOverdraftFeeChargeDetail.overdraftFeeChargeCap) && Objects.equals(this.otherFeeType, overdraftOverdraftFeeChargeDetail.otherFeeType) && Objects.equals(this.otherFeeRateType, overdraftOverdraftFeeChargeDetail.otherFeeRateType) && Objects.equals(this.otherApplicationFrequency, overdraftOverdraftFeeChargeDetail.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, overdraftOverdraftFeeChargeDetail.otherCalculationFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.negotiableIndicator, this.overdraftControlIndicator, this.incrementalBorrowingAmount, this.feeAmount, this.feeRate, this.feeRateType, this.applicationFrequency, this.calculationFrequency, this.notes, this.overdraftFeeChargeCap, this.otherFeeType, this.otherFeeRateType, this.otherApplicationFrequency, this.otherCalculationFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OverdraftOverdraftFeeChargeDetail {\n");
        sb.append("    feeType: ").append(this.toIndentedString((Object)this.feeType)).append("\n");
        sb.append("    negotiableIndicator: ").append(this.toIndentedString(this.negotiableIndicator)).append("\n");
        sb.append("    overdraftControlIndicator: ").append(this.toIndentedString(this.overdraftControlIndicator)).append("\n");
        sb.append("    incrementalBorrowingAmount: ").append(this.toIndentedString(this.incrementalBorrowingAmount)).append("\n");
        sb.append("    feeAmount: ").append(this.toIndentedString(this.feeAmount)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    feeRateType: ").append(this.toIndentedString((Object)this.feeRateType)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftFeeChargeCap: ").append(this.toIndentedString(this.overdraftFeeChargeCap)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("    otherFeeRateType: ").append(this.toIndentedString(this.otherFeeRateType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalculationFrequencyEnum {
        ONCLOSING("OnClosing"),
        ONOPENING("OnOpening"),
        CHARGINGPERIOD("ChargingPeriod"),
        DAILY("Daily"),
        PERITEM("PerItem"),
        MONTHLY("Monthly"),
        ONANNIVERSARY("OnAnniversary"),
        OTHER("Other"),
        PERHUNDREDPOUNDS("PerHundredPounds"),
        PERHOUR("PerHour"),
        PEROCCURRENCE("PerOccurrence"),
        PERSHEET("PerSheet"),
        PERTRANSACTION("PerTransaction"),
        PERTRANSACTIONAMOUNT("PerTransactionAmount"),
        PERTRANSACTIONPERCENTAGE("PerTransactionPercentage"),
        QUARTERLY("Quarterly"),
        SIXMONTHLY("SixMonthly"),
        STATEMENTMONTHLY("StatementMonthly"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private CalculationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CalculationFrequencyEnum fromValue(String text) {
            for (CalculationFrequencyEnum b : CalculationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ApplicationFrequencyEnum {
        ONCLOSING("OnClosing"),
        ONOPENING("OnOpening"),
        CHARGINGPERIOD("ChargingPeriod"),
        DAILY("Daily"),
        PERITEM("PerItem"),
        MONTHLY("Monthly"),
        ONANNIVERSARY("OnAnniversary"),
        OTHER("Other"),
        PERHUNDREDPOUNDS("PerHundredPounds"),
        PERHOUR("PerHour"),
        PEROCCURRENCE("PerOccurrence"),
        PERSHEET("PerSheet"),
        PERTRANSACTION("PerTransaction"),
        PERTRANSACTIONAMOUNT("PerTransactionAmount"),
        PERTRANSACTIONPERCENTAGE("PerTransactionPercentage"),
        QUARTERLY("Quarterly"),
        SIXMONTHLY("SixMonthly"),
        STATEMENTMONTHLY("StatementMonthly"),
        WEEKLY("Weekly"),
        YEARLY("Yearly");

        private String value;

        private ApplicationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ApplicationFrequencyEnum fromValue(String text) {
            for (ApplicationFrequencyEnum b : ApplicationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeRateTypeEnum {
        GROSS("Gross"),
        OTHER("Other");

        private String value;

        private FeeRateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeRateTypeEnum fromValue(String text) {
            for (FeeRateTypeEnum b : FeeRateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeTypeEnum {
        ARRANGEDOVERDRAFT("ArrangedOverdraft"),
        ANNUALREVIEW("AnnualReview"),
        EMERGENCYBORROWING("EmergencyBorrowing"),
        BORROWINGITEM("BorrowingItem"),
        OVERDRAFTRENEWAL("OverdraftRenewal"),
        OVERDRAFTSETUP("OverdraftSetup"),
        SURCHARGE("Surcharge"),
        TEMPOVERDRAFT("TempOverdraft"),
        UNAUTHORISEDBORROWING("UnauthorisedBorrowing"),
        UNAUTHORISEDPAIDTRANS("UnauthorisedPaidTrans"),
        OTHER("Other"),
        UNAUTHORISEDUNPAIDTRANS("UnauthorisedUnpaidTrans");

        private String value;

        private FeeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeTypeEnum fromValue(String text) {
            for (FeeTypeEnum b : FeeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

