/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OverdraftOverdraftFeesCharges;

@ApiModel(description="Provides overdraft details for a specific tier or band")
public class OverdraftOverdraftTierBand {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMin")
    private String tierValueMin = null;
    @JsonProperty(value="TierValueMax")
    private String tierValueMax = null;
    @JsonProperty(value="EAR")
    private String EAR = null;
    @JsonProperty(value="AgreementLengthMin")
    private Float agreementLengthMin = null;
    @JsonProperty(value="AgreementLengthMax")
    private Float agreementLengthMax = null;
    @JsonProperty(value="AgreementPeriod")
    private AgreementPeriodEnum agreementPeriod = null;
    @JsonProperty(value="OverdraftInterestChargingCoverage")
    private OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage = null;
    @JsonProperty(value="BankGuaranteedIndicator")
    private Boolean bankGuaranteedIndicator = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OverdraftFeesCharges")
    private List<OverdraftOverdraftFeesCharges> overdraftFeesCharges = null;

    public OverdraftOverdraftTierBand identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a overdraft.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OverdraftOverdraftTierBand tierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="Minimum value of Overdraft Tier/Band")
    public String getTierValueMin() {
        return this.tierValueMin;
    }

    public void setTierValueMin(String tierValueMin) {
        this.tierValueMin = tierValueMin;
    }

    public OverdraftOverdraftTierBand tierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Maximum value of Overdraft Tier/Band")
    public String getTierValueMax() {
        return this.tierValueMax;
    }

    public void setTierValueMax(String tierValueMax) {
        this.tierValueMax = tierValueMax;
    }

    public OverdraftOverdraftTierBand EAR(String EAR) {
        this.EAR = EAR;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="EAR means Effective Annual Rate and/or Equivalent Annual Rate (frequently used interchangeably), being the actual annual interest rate of an Overdraft.")
    public String getEAR() {
        return this.EAR;
    }

    public void setEAR(String EAR) {
        this.EAR = EAR;
    }

    public OverdraftOverdraftTierBand agreementLengthMin(Float agreementLengthMin) {
        this.agreementLengthMin = agreementLengthMin;
        return this;
    }

    @ApiModelProperty(value="Specifies the minimum length of a band for a fixed overdraft agreement")
    public Float getAgreementLengthMin() {
        return this.agreementLengthMin;
    }

    public void setAgreementLengthMin(Float agreementLengthMin) {
        this.agreementLengthMin = agreementLengthMin;
    }

    public OverdraftOverdraftTierBand agreementLengthMax(Float agreementLengthMax) {
        this.agreementLengthMax = agreementLengthMax;
        return this;
    }

    @ApiModelProperty(value="Specifies the maximum length of a band for a fixed overdraft agreement")
    public Float getAgreementLengthMax() {
        return this.agreementLengthMax;
    }

    public void setAgreementLengthMax(Float agreementLengthMax) {
        this.agreementLengthMax = agreementLengthMax;
    }

    public OverdraftOverdraftTierBand agreementPeriod(AgreementPeriodEnum agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
        return this;
    }

    @ApiModelProperty(value="Specifies the period of a fixed length overdraft agreement")
    public AgreementPeriodEnum getAgreementPeriod() {
        return this.agreementPeriod;
    }

    public void setAgreementPeriod(AgreementPeriodEnum agreementPeriod) {
        this.agreementPeriod = agreementPeriod;
    }

    public OverdraftOverdraftTierBand overdraftInterestChargingCoverage(OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
        return this;
    }

    @ApiModelProperty(value="Refers to which interest rate is applied when interests are tiered. For example, if an overdraft balance is \u00a32k and the interest tiers are:- 0-\u00a3500 0.1%, 500-1000 0.2%, 1000-10000 0.5%, then the applicable interest rate could either be 0.5% of the entire balance (since the account balance sits in the top interest tier) or (0.1%*500)+(0.2%*500)+(0.5%*1000). In the 1st situation, we say the interest is applied to the \u2018Whole\u2019 of the account balance,  and in the 2nd that it is \u2018Tiered\u2019.")
    public OverdraftInterestChargingCoverageEnum getOverdraftInterestChargingCoverage() {
        return this.overdraftInterestChargingCoverage;
    }

    public void setOverdraftInterestChargingCoverage(OverdraftInterestChargingCoverageEnum overdraftInterestChargingCoverage) {
        this.overdraftInterestChargingCoverage = overdraftInterestChargingCoverage;
    }

    public OverdraftOverdraftTierBand bankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the advertised overdraft rate is guaranteed to be offered to a borrower by the bank e.g. if it\u2019s part of a government scheme, or whether the rate may vary dependent on the applicant\u2019s circumstances.")
    public Boolean isBankGuaranteedIndicator() {
        return this.bankGuaranteedIndicator;
    }

    public void setBankGuaranteedIndicator(Boolean bankGuaranteedIndicator) {
        this.bankGuaranteedIndicator = bankGuaranteedIndicator;
    }

    public OverdraftOverdraftTierBand notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OverdraftOverdraftTierBand addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier/band details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OverdraftOverdraftTierBand overdraftFeesCharges(List<OverdraftOverdraftFeesCharges> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
        return this;
    }

    public OverdraftOverdraftTierBand addOverdraftFeesChargesItem(OverdraftOverdraftFeesCharges overdraftFeesChargesItem) {
        if (this.overdraftFeesCharges == null) {
            this.overdraftFeesCharges = new ArrayList<OverdraftOverdraftFeesCharges>();
        }
        this.overdraftFeesCharges.add(overdraftFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Overdraft fees and charges")
    public List<OverdraftOverdraftFeesCharges> getOverdraftFeesCharges() {
        return this.overdraftFeesCharges;
    }

    public void setOverdraftFeesCharges(List<OverdraftOverdraftFeesCharges> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverdraftOverdraftTierBand overdraftOverdraftTierBand = (OverdraftOverdraftTierBand)o;
        return Objects.equals(this.identification, overdraftOverdraftTierBand.identification) && Objects.equals(this.tierValueMin, overdraftOverdraftTierBand.tierValueMin) && Objects.equals(this.tierValueMax, overdraftOverdraftTierBand.tierValueMax) && Objects.equals(this.EAR, overdraftOverdraftTierBand.EAR) && Objects.equals(this.agreementLengthMin, overdraftOverdraftTierBand.agreementLengthMin) && Objects.equals(this.agreementLengthMax, overdraftOverdraftTierBand.agreementLengthMax) && Objects.equals((Object)this.agreementPeriod, (Object)overdraftOverdraftTierBand.agreementPeriod) && Objects.equals((Object)this.overdraftInterestChargingCoverage, (Object)overdraftOverdraftTierBand.overdraftInterestChargingCoverage) && Objects.equals(this.bankGuaranteedIndicator, overdraftOverdraftTierBand.bankGuaranteedIndicator) && Objects.equals(this.notes, overdraftOverdraftTierBand.notes) && Objects.equals(this.overdraftFeesCharges, overdraftOverdraftTierBand.overdraftFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMin, this.tierValueMax, this.EAR, this.agreementLengthMin, this.agreementLengthMax, this.agreementPeriod, this.overdraftInterestChargingCoverage, this.bankGuaranteedIndicator, this.notes, this.overdraftFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OverdraftOverdraftTierBand {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMin: ").append(this.toIndentedString(this.tierValueMin)).append("\n");
        sb.append("    tierValueMax: ").append(this.toIndentedString(this.tierValueMax)).append("\n");
        sb.append("    EAR: ").append(this.toIndentedString(this.EAR)).append("\n");
        sb.append("    agreementLengthMin: ").append(this.toIndentedString(this.agreementLengthMin)).append("\n");
        sb.append("    agreementLengthMax: ").append(this.toIndentedString(this.agreementLengthMax)).append("\n");
        sb.append("    agreementPeriod: ").append(this.toIndentedString((Object)this.agreementPeriod)).append("\n");
        sb.append("    overdraftInterestChargingCoverage: ").append(this.toIndentedString((Object)this.overdraftInterestChargingCoverage)).append("\n");
        sb.append("    bankGuaranteedIndicator: ").append(this.toIndentedString(this.bankGuaranteedIndicator)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftFeesCharges: ").append(this.toIndentedString(this.overdraftFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OverdraftInterestChargingCoverageEnum {
        BANDED("Banded"),
        TIERED("Tiered"),
        WHOLE("Whole");

        private String value;

        private OverdraftInterestChargingCoverageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OverdraftInterestChargingCoverageEnum fromValue(String text) {
            for (OverdraftInterestChargingCoverageEnum b : OverdraftInterestChargingCoverageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum AgreementPeriodEnum {
        DAY("Day"),
        HALF_YEAR("Half Year"),
        MONTH("Month"),
        QUARTER("Quarter"),
        WEEK("Week"),
        YEAR("Year");

        private String value;

        private AgreementPeriodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AgreementPeriodEnum fromValue(String text) {
            for (AgreementPeriodEnum b : AgreementPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

