/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="Set of elements to fully identify a proprietary bank transaction code.")
public class ProprietaryBankTransactionCodeStructure1 {
    @JsonProperty(value="Code")
    private String code = null;
    @JsonProperty(value="Issuer")
    private String issuer = null;

    public ProprietaryBankTransactionCodeStructure1 code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="Proprietary bank transaction code to identify the underlying transaction.")
    @NotNull
    @Size(min=1, max=35)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ProprietaryBankTransactionCodeStructure1 issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(value="Identification of the issuer of the proprietary bank transaction code.")
    @Size(min=1, max=35)
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProprietaryBankTransactionCodeStructure1 data3ProprietaryBankTransactionCode = (ProprietaryBankTransactionCodeStructure1)o;
        return Objects.equals(this.code, data3ProprietaryBankTransactionCode.code) && Objects.equals(this.issuer, data3ProprietaryBankTransactionCode.issuer);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.issuer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Data3ProprietaryBankTransactionCode {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

